/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.shared.network.codec.MoreStreamCodecs;
import dan200.computercraft.shared.recipe.RecipeProperties;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public record ShapelessRecipeSpec(RecipeProperties properties, NonNullList<Ingredient> ingredients, ItemStack result) {
    private static final Codec<NonNullList<Ingredient>> INGREDIENT_CODEC = Ingredient.CODEC_NONEMPTY.listOf().flatXmap(list -> {
        Object[] ingredients = (Ingredient[])list.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
        if (ingredients.length == 0) {
            return DataResult.error(() -> "No ingredients for shapeless recipe");
        }
        if (ingredients.length > 9) {
            return DataResult.error(() -> "Too many ingredients for shapeless recipe");
        }
        return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
    }, DataResult::success);
    public static final MapCodec<ShapelessRecipeSpec> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecipeProperties.CODEC.forGetter(ShapelessRecipeSpec::properties), (App)INGREDIENT_CODEC.fieldOf("ingredients").forGetter(ShapelessRecipeSpec::ingredients), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(ShapelessRecipeSpec::result)).apply((Applicative)instance, ShapelessRecipeSpec::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipeSpec> STREAM_CODEC = StreamCodec.composite(RecipeProperties.STREAM_CODEC, ShapelessRecipeSpec::properties, MoreStreamCodecs.nonNullList(Ingredient.CONTENTS_STREAM_CODEC, Ingredient.EMPTY), ShapelessRecipeSpec::ingredients, (StreamCodec)ItemStack.STREAM_CODEC, ShapelessRecipeSpec::result, ShapelessRecipeSpec::new);

    public ShapelessRecipe create() {
        return new ShapelessRecipe(this.properties().group(), this.properties().category(), this.result(), this.ingredients());
    }
}

