/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import rbasamoyai.escalated.index.EscalatedDataComponents;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwayConnectorItem;

public class WalkwayConnectorHandler {
    private static final Random RANDOM = new Random();

    public static void tick() {
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        if (player == null || level == null) {
            return;
        }
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            boolean escalator;
            ItemStack heldItem = player.getItemInHand(hand);
            Item item = heldItem.getItem();
            if (!(item instanceof WalkwayConnectorItem)) continue;
            WalkwayConnectorItem walkwayItem = (WalkwayConnectorItem)item;
            if (!heldItem.has(EscalatedDataComponents.WALKWAY_FIRST_TERMINAL)) continue;
            BlockPos firstPos = (BlockPos)heldItem.get(EscalatedDataComponents.WALKWAY_FIRST_TERMINAL);
            BlockState firstState = level.getBlockState(firstPos);
            Direction.Axis axis = Direction.Axis.Y;
            if (ShaftBlock.isShaft((BlockState)firstState)) {
                axis = (Direction.Axis)firstState.getValue((Property)BlockStateProperties.AXIS);
            } else {
                KineticBlock kinetic;
                Block block = firstState.getBlock();
                if (block instanceof KineticBlock && (kinetic = (KineticBlock)block) instanceof WalkwayBlock) {
                    axis = kinetic.getRotationAxis(firstState);
                }
            }
            if (axis == Direction.Axis.Y) {
                return;
            }
            HitResult rayTrace = Minecraft.getInstance().hitResult;
            if (rayTrace == null || !(rayTrace instanceof BlockHitResult)) {
                if (RANDOM.nextInt(50) == 0) {
                    level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.3f, 0.9f, 0.5f), 1.0f), (double)((float)firstPos.getX() + 0.5f + WalkwayConnectorHandler.randomOffset(0.25f)), (double)((float)firstPos.getY() + 0.5f + WalkwayConnectorHandler.randomOffset(0.25f)), (double)((float)firstPos.getZ() + 0.5f + WalkwayConnectorHandler.randomOffset(0.25f)), 0.0, 0.0, 0.0);
                }
                return;
            }
            BlockPos selected = ((BlockHitResult)rayTrace).getBlockPos();
            BlockState secondState = level.getBlockState(selected);
            if (secondState.canBeReplaced()) {
                return;
            }
            if (!ShaftBlock.isShaft((BlockState)secondState) && !(secondState.getBlock() instanceof WalkwayBlock)) {
                selected = selected.relative(((BlockHitResult)rayTrace).getDirection());
            }
            boolean bl = escalator = selected.getY() - firstPos.getY() != 0;
            if (!escalator && !selected.closerThan((Vec3i)firstPos, (double)walkwayItem.maxWalkwayLength()) || escalator && Math.abs(selected.getY() - firstPos.getY()) > walkwayItem.maxEscalatorHeight()) {
                return;
            }
            boolean canConnect = WalkwayConnectorItem.validateAxis((Level)level, selected) && walkwayItem.canConnect((Level)level, firstPos, selected);
            BlockPos diffPos = selected.subtract((Vec3i)firstPos);
            boolean extendingWalkway = Math.abs(axis.choose(diffPos.getX(), diffPos.getY(), diffPos.getZ())) == 1;
            Vec3 start = Vec3.atLowerCornerOf((Vec3i)firstPos);
            Vec3 end = Vec3.atLowerCornerOf((Vec3i)selected);
            Vec3 diff = end.subtract(start);
            if (extendingWalkway) {
                List<Object> list = new ArrayList();
                Vec3 extensionOffset = new Vec3((double)axis.choose(diffPos.getX(), 0, 0), 0.0, (double)axis.choose(0, 0, diffPos.getZ()));
                BlockEntity blockEntity = level.getBlockEntity(firstPos);
                if (blockEntity instanceof WalkwayBlockEntity) {
                    WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)blockEntity;
                    list = walkwayBE.getAllBlocks();
                } else {
                    blockEntity = level.getBlockEntity(selected);
                    if (blockEntity instanceof WalkwayBlockEntity) {
                        WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)blockEntity;
                        list = walkwayBE.getAllBlocks();
                        extensionOffset = extensionOffset.reverse();
                    }
                }
                if (list.isEmpty()) {
                    return;
                }
                start = Vec3.atLowerCornerOf((Vec3i)((Vec3i)list.get(0)));
                end = Vec3.atLowerCornerOf((Vec3i)((Vec3i)list.get(list.size() - 1)));
                diff = end.subtract(start);
                start = start.add(extensionOffset);
            }
            double x = Math.abs(diff.x);
            double y = Math.abs(diff.y);
            double z = Math.abs(diff.z);
            float length = (float)diff.length();
            Vec3 step = diff.normalize();
            for (float f = 0.0f; f < length; f += 0.0625f) {
                Vec3 position = start.add(step.scale((double)f));
                if (RANDOM.nextInt(10) != 0) continue;
                level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(canConnect ? 0.3f : 0.9f, canConnect ? 0.9f : 0.3f, 0.5f), 1.0f), position.x + 0.5, position.y + 0.5, position.z + 0.5, 0.0, 0.0, 0.0);
            }
            return;
        }
    }

    private static float randomOffset(float range) {
        return (RANDOM.nextFloat() - 0.5f) * 2.0f * range;
    }
}

