/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.index;

import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import rbasamoyai.escalated.CreateEscalated;

public class EscalatedBlockPartials {
    private static final Collection<Runnable> DEFERRED_MODEL_CALLBACKS = new ArrayList<Runnable>();
    public static final PartialModel METAL_ESCALATOR_STEP = EscalatedBlockPartials.escalatorSteps("metal");
    public static final PartialModel METAL_ESCALATOR_STEP_LEFT = EscalatedBlockPartials.escalatorSteps("metal", "_left");
    public static final PartialModel METAL_ESCALATOR_STEP_RIGHT = EscalatedBlockPartials.escalatorSteps("metal", "_right");
    public static final PartialModel METAL_ESCALATOR_STEP_CENTER = EscalatedBlockPartials.escalatorSteps("metal", "_center");
    public static final PartialModel METAL_WALKWAY_STEP = EscalatedBlockPartials.walkwaySteps("metal");
    public static final PartialModel METAL_WALKWAY_STEP_LEFT = EscalatedBlockPartials.walkwaySteps("metal", "_left");
    public static final PartialModel METAL_WALKWAY_STEP_RIGHT = EscalatedBlockPartials.walkwaySteps("metal", "_right");
    public static final PartialModel METAL_WALKWAY_STEP_CENTER = EscalatedBlockPartials.walkwaySteps("metal", "_center");
    public static final Map<DyeColor, PartialModel> DYED_METAL_ESCALATOR_STEPS = EscalatedBlockPartials.dyedEscalatorSteps("metal");
    public static final Map<DyeColor, PartialModel> DYED_METAL_ESCALATOR_STEPS_LEFT = EscalatedBlockPartials.dyedEscalatorSteps("metal", "_left");
    public static final Map<DyeColor, PartialModel> DYED_METAL_ESCALATOR_STEPS_RIGHT = EscalatedBlockPartials.dyedEscalatorSteps("metal", "_right");
    public static final Map<DyeColor, PartialModel> DYED_METAL_ESCALATOR_STEPS_CENTER = EscalatedBlockPartials.dyedEscalatorSteps("metal", "_center");
    public static final Map<DyeColor, PartialModel> DYED_METAL_WALKWAY_STEPS = EscalatedBlockPartials.dyedWalkwaySteps("metal");
    public static final Map<DyeColor, PartialModel> DYED_METAL_WALKWAY_STEPS_LEFT = EscalatedBlockPartials.dyedWalkwaySteps("metal", "_left");
    public static final Map<DyeColor, PartialModel> DYED_METAL_WALKWAY_STEPS_RIGHT = EscalatedBlockPartials.dyedWalkwaySteps("metal", "_right");
    public static final Map<DyeColor, PartialModel> DYED_METAL_WALKWAY_STEPS_CENTER = EscalatedBlockPartials.dyedWalkwaySteps("metal", "_center");
    public static final PartialModel WOODEN_ESCALATOR_STEP = EscalatedBlockPartials.escalatorSteps("wooden");
    public static final PartialModel WOODEN_ESCALATOR_STEP_LEFT = EscalatedBlockPartials.escalatorSteps("wooden", "_left");
    public static final PartialModel WOODEN_ESCALATOR_STEP_RIGHT = EscalatedBlockPartials.escalatorSteps("wooden", "_right");
    public static final PartialModel WOODEN_ESCALATOR_STEP_CENTER = EscalatedBlockPartials.escalatorSteps("wooden", "_center");
    public static final PartialModel WOODEN_WALKWAY_STEP = EscalatedBlockPartials.walkwaySteps("wooden");
    public static final PartialModel WOODEN_WALKWAY_STEP_LEFT = EscalatedBlockPartials.walkwaySteps("wooden", "_left");
    public static final PartialModel WOODEN_WALKWAY_STEP_RIGHT = EscalatedBlockPartials.walkwaySteps("wooden", "_right");
    public static final PartialModel WOODEN_WALKWAY_STEP_CENTER = EscalatedBlockPartials.walkwaySteps("wooden", "_center");
    public static final Map<DyeColor, PartialModel> DYED_WOODEN_ESCALATOR_STEPS = EscalatedBlockPartials.dyedEscalatorSteps("wooden");
    public static final Map<DyeColor, PartialModel> DYED_WOODEN_ESCALATOR_STEPS_LEFT = EscalatedBlockPartials.dyedEscalatorSteps("wooden", "_left");
    public static final Map<DyeColor, PartialModel> DYED_WOODEN_ESCALATOR_STEPS_RIGHT = EscalatedBlockPartials.dyedEscalatorSteps("wooden", "_right");
    public static final Map<DyeColor, PartialModel> DYED_WOODEN_ESCALATOR_STEPS_CENTER = EscalatedBlockPartials.dyedEscalatorSteps("wooden", "_center");
    public static final Map<DyeColor, PartialModel> DYED_WOODEN_WALKWAY_STEPS = EscalatedBlockPartials.dyedWalkwaySteps("wooden");
    public static final Map<DyeColor, PartialModel> DYED_WOODEN_WALKWAY_STEPS_LEFT = EscalatedBlockPartials.dyedWalkwaySteps("wooden", "_left");
    public static final Map<DyeColor, PartialModel> DYED_WOODEN_WALKWAY_STEPS_RIGHT = EscalatedBlockPartials.dyedWalkwaySteps("wooden", "_right");
    public static final Map<DyeColor, PartialModel> DYED_WOODEN_WALKWAY_STEPS_CENTER = EscalatedBlockPartials.dyedWalkwaySteps("wooden", "_center");
    public static final PartialModel HANDRAIL_START = EscalatedBlockPartials.handrail("start");
    public static final PartialModel HANDRAIL_END = EscalatedBlockPartials.handrail("end");
    public static final PartialModel HANDRAIL_HORIZONTAL = EscalatedBlockPartials.handrail("horizontal");
    public static final PartialModel HANDRAIL_BOTTOM = EscalatedBlockPartials.handrail("bottom");
    public static final PartialModel HANDRAIL_MIDDLE = EscalatedBlockPartials.handrail("middle");
    public static final PartialModel HANDRAIL_TOP = EscalatedBlockPartials.handrail("top");

    private static PartialModel escalatorSteps(String material) {
        return EscalatedBlockPartials.escalatorSteps(material, "");
    }

    private static PartialModel escalatorSteps(String material, String suffix) {
        return PartialModel.of((ResourceLocation)CreateEscalated.resource("block/" + material + "_escalator_step" + suffix));
    }

    private static PartialModel walkwaySteps(String material) {
        return EscalatedBlockPartials.walkwaySteps(material, "");
    }

    private static PartialModel walkwaySteps(String material, String suffix) {
        return PartialModel.of((ResourceLocation)CreateEscalated.resource("block/" + material + "_walkway_step" + suffix));
    }

    private static Map<DyeColor, PartialModel> dyedEscalatorSteps(String material) {
        EnumMap<DyeColor, PartialModel> map = new EnumMap<DyeColor, PartialModel>(DyeColor.class);
        for (DyeColor color : DyeColor.values()) {
            map.put(color, EscalatedBlockPartials.escalatorSteps(material, "_" + color.getName()));
        }
        return map;
    }

    private static Map<DyeColor, PartialModel> dyedEscalatorSteps(String material, String suffix) {
        EnumMap<DyeColor, PartialModel> map = new EnumMap<DyeColor, PartialModel>(DyeColor.class);
        for (DyeColor color : DyeColor.values()) {
            map.put(color, EscalatedBlockPartials.escalatorSteps(material, suffix + "_" + color.getName()));
        }
        return map;
    }

    private static Map<DyeColor, PartialModel> dyedWalkwaySteps(String material) {
        EnumMap<DyeColor, PartialModel> map = new EnumMap<DyeColor, PartialModel>(DyeColor.class);
        for (DyeColor color : DyeColor.values()) {
            map.put(color, EscalatedBlockPartials.walkwaySteps(material, "_" + color.getName()));
        }
        return map;
    }

    private static Map<DyeColor, PartialModel> dyedWalkwaySteps(String material, String suffix) {
        EnumMap<DyeColor, PartialModel> map = new EnumMap<DyeColor, PartialModel>(DyeColor.class);
        for (DyeColor color : DyeColor.values()) {
            map.put(color, EscalatedBlockPartials.walkwaySteps(material, suffix + "_" + color.getName()));
        }
        return map;
    }

    private static PartialModel handrail(String type) {
        return PartialModel.of((ResourceLocation)CreateEscalated.resource("block/moving_handrail/" + type));
    }

    public static void init() {
    }

    public static void resolveDeferredModels() {
        for (Runnable run : DEFERRED_MODEL_CALLBACKS) {
            run.run();
        }
        DEFERRED_MODEL_CALLBACKS.clear();
    }
}

