/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.text.content;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.util.text.content.AdvancedContent;
import team.creative.creativecore.common.util.text.content.AdvancedFormattedText;

public record ContentItemStack(ItemStack stack) implements AdvancedContent
{
    public static final MapCodec<ContentItemStack> CODEC = RecordCodecBuilder.mapCodec(content -> content.group((App)ItemStack.CODEC.fieldOf("stack").forGetter(ContentItemStack::stack)).apply((Applicative)content, ContentItemStack::new));
    public static final ComponentContents.Type<ContentItemStack> TYPE = new ComponentContents.Type(CODEC, "stack");

    public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> consumer, Style style) {
        return this.stack.getHoverName().visit(consumer, style);
    }

    public <T> Optional<T> visit(FormattedText.ContentConsumer<T> consumer) {
        return this.stack.getHoverName().visit(consumer);
    }

    @Override
    public int width(StringSplitter.WidthProvider widthProvider, Style style) {
        return 14;
    }

    @Override
    public int height() {
        return 8;
    }

    @Override
    public FormattedText asText() {
        return new ContentItemStackText(this);
    }

    public ComponentContents.Type<?> type() {
        return TYPE;
    }

    private record ContentItemStackText(ContentItemStack content) implements AdvancedFormattedText
    {
        @Override
        public int width(StringSplitter.WidthProvider widthProvider, Style style) {
            return this.content.width(widthProvider, style);
        }

        @Override
        public int height() {
            return this.content.height();
        }

        @Override
        public void render(GuiGraphics graphics, int defaultColor) {
            PoseStack pose = graphics.pose();
            pose.pushPose();
            pose.translate(0.0f, -2.0f, 10.0f);
            pose.scale(0.8f, 0.8f, 0.8f);
            GuiRenderHelper.drawItemStack(graphics, this.content.stack, 1.0f);
            pose.popPose();
        }
    }
}

