/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.neoforge;

import immersive_aircraft.ClientMain;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.item.upgrade.VehicleUpgrade;
import immersive_aircraft.item.upgrade.VehicleUpgradeRegistry;
import immersive_aircraft.neoforge.cobalt.registration.RegistrationImpl;
import immersive_aircraft.network.s2c.AircraftDataMessage;
import immersive_aircraft.network.s2c.VehicleUpgradesMessage;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="immersive_aircraft")
public class NeoForgeBusEvents {
    public static RegistrationImpl.DataLoaderRegister DATA_REGISTRY;
    public static RegistrationImpl.DataLoaderRegister RESOURCE_REGISTRY;
    private static final DecimalFormat fmt;
    public static boolean firstLoad;

    @SubscribeEvent
    public static void onClientStart(ClientTickEvent.Pre event) {
        if (firstLoad) {
            ClientMain.postLoad();
            firstLoad = false;
        }
        ClientMain.tick();
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        if (DATA_REGISTRY != null) {
            for (PreparableReloadListener loader : DATA_REGISTRY.getLoaders()) {
                event.addListener(loader);
            }
        }
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            NetworkHandler.sendToPlayer(new VehicleUpgradesMessage(), event.getPlayer());
            NetworkHandler.sendToPlayer(new AircraftDataMessage(), event.getPlayer());
        } else {
            for (ServerPlayer player : event.getPlayerList().getPlayers()) {
                NetworkHandler.sendToPlayer(new VehicleUpgradesMessage(), player);
                NetworkHandler.sendToPlayer(new AircraftDataMessage(), player);
            }
        }
    }

    @SubscribeEvent
    public static void onItemTooltips(ItemTooltipEvent event) {
        VehicleUpgrade upgrade = VehicleUpgradeRegistry.INSTANCE.getUpgrade(event.getItemStack().getItem());
        if (upgrade != null) {
            List tooltip = event.getToolTip();
            tooltip.add(Component.translatable((String)"item.immersive_aircraft.item.upgrade").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
            for (Map.Entry<VehicleStat, Float> entry : upgrade.getAll().entrySet()) {
                tooltip.add(Component.translatable((String)("immersive_aircraft.upgrade." + entry.getKey().name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{fmt.format(entry.getValue().floatValue() * 100.0f)}).withStyle(entry.getValue().floatValue() * (float)(entry.getKey().positive() ? 1 : -1) > 0.0f ? ChatFormatting.GREEN : ChatFormatting.RED));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getEntity().getRootVehicle() instanceof VehicleEntity) {
            event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
        }
    }

    static {
        fmt = new DecimalFormat("+#;-#");
        firstLoad = true;
    }
}

