/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapon;

import immersive_aircraft.Entities;
import immersive_aircraft.Sounds;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.bullet.BulletEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapon.BulletWeapon;
import immersive_aircraft.entity.weapon.RotationalManager;
import immersive_aircraft.network.c2s.FireMessage;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class RotaryCannon
extends BulletWeapon {
    private final RotationalManager rotationalManager = new RotationalManager(this);

    public RotaryCannon(VehicleEntity entity, ItemStack stack, WeaponMount mount, int slot) {
        super(entity, stack, mount, slot);
    }

    @Override
    protected Vector4f getBarrelOffset() {
        return new Vector4f(0.0f, 0.825f, -0.375f, 1.0f);
    }

    public float getVelocity() {
        return 4.0f;
    }

    public float getInaccuracy() {
        return 1.0f;
    }

    @Override
    protected Entity getBullet(Vector4f position, Vector3f direction) {
        BulletEntity bullet = (BulletEntity)Entities.BULLET.get().create(this.getEntity().level());
        assert (bullet != null);
        bullet.setDamage(Config.getInstance().rotaryCannonDamage);
        bullet.setPos(position.x(), position.y(), position.z());
        bullet.setOwner((Entity)this.getEntity().getControllingPassenger());
        bullet.shoot(direction.x(), direction.y(), direction.z(), this.getVelocity(), this.getInaccuracy());
        return bullet;
    }

    @Override
    public void tick() {
        this.rotationalManager.tick();
        this.rotationalManager.pointTo(this.getEntity());
    }

    @Override
    public void fire(Vector3f direction) {
        if (this.spentAmmo(Config.getInstance().gunpowderAmmunition, 10)) {
            super.fire(direction);
        }
    }

    @Override
    public SoundEvent getSound() {
        return Sounds.CANNON.get();
    }

    private Vector3f getDirection() {
        return this.rotationalManager.screenToGlobal(this.getEntity());
    }

    @Override
    public void clientFire(int index) {
        float old = this.rotationalManager.roll;
        this.rotationalManager.roll += 0.25f;
        if (Math.floor(old) != Math.floor(this.rotationalManager.roll)) {
            NetworkHandler.sendToServer(new FireMessage(this.getSlot(), index, this.getDirection()));
        }
    }

    @Override
    public <T extends VehicleEntity> void setAnimationVariables(T entity, float time) {
        super.setAnimationVariables(entity, time);
        float tickDelta = time % 1.0f;
        BBAnimationVariables.set("pitch", (float)((double)this.rotationalManager.getPitch(tickDelta) / Math.PI * 180.0));
        BBAnimationVariables.set("yaw", (float)((double)this.rotationalManager.getYaw(tickDelta) / Math.PI * 180.0));
        BBAnimationVariables.set("roll", (float)((double)this.rotationalManager.getRoll(tickDelta) / Math.PI * 180.0));
    }
}

