/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content;

import com.hlysine.create_power_loader.config.CPLConfigs;
import com.hlysine.create_power_loader.content.AbstractChunkLoaderBlock;
import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.LoaderType;
import com.hlysine.create_power_loader.content.trains.CPLGlobalStation;
import com.hlysine.create_power_loader.content.trains.StationChunkLoader;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import java.util.HashSet;
import java.util.Set;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChunkLoaderBlockEntity
extends KineticBlockEntity
implements ChunkLoader {
    public final LoaderType type;
    protected BlockPos lastBlockPos;
    protected boolean lastEnabled;
    protected int lastRange;
    protected int chunkUpdateCooldown;
    protected int chunkUnloadCooldown;
    protected Set<ChunkLoadManager.LoadedChunkPos> forcedChunks = new HashSet<ChunkLoadManager.LoadedChunkPos>();
    @Nullable
    private StationBlockEntity attachedStation = null;
    public boolean isLoaderActive = false;
    private boolean deferredEdgePoint = false;

    public AbstractChunkLoaderBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state, LoaderType type) {
        super(typeIn, pos, state);
        this.type = type;
    }

    @Override
    @NotNull
    public Set<ChunkLoadManager.LoadedChunkPos> getForcedChunks() {
        return this.forcedChunks;
    }

    @Override
    public LoaderMode getLoaderMode() {
        return LoaderMode.STATIC;
    }

    @Override
    public LoaderType getLoaderType() {
        return this.type;
    }

    @Override
    @Nullable
    public Pair<ResourceLocation, BlockPos> getLocation() {
        return Pair.of((Object)this.getLevel().dimension().location(), (Object)this.getBlockPos());
    }

    public void updateAttachedStation(StationBlockEntity be) {
        CPLGlobalStation station;
        GlobalStation globalStation;
        if (this.attachedStation != null) {
            globalStation = this.attachedStation.getStation();
            if (globalStation instanceof CPLGlobalStation) {
                station = (CPLGlobalStation)globalStation;
                station.getLoader().removeAttachment(this.getBlockPos());
            }
        } else {
            this.removeFromManager();
        }
        this.attachedStation = be;
        if (this.attachedStation != null) {
            globalStation = this.attachedStation.getStation();
            if (globalStation instanceof CPLGlobalStation) {
                station = (CPLGlobalStation)globalStation;
                station.getLoader().addAttachment(this.type, this.getBlockPos());
            } else {
                this.deferredEdgePoint = true;
            }
        } else if (!this.level.isClientSide()) {
            this.addToManager();
        }
    }

    public StationBlockEntity getAttachedStation() {
        return this.attachedStation;
    }

    public void initialize() {
        super.initialize();
        if (this.getLevel() != null && ((Boolean)this.getBlockState().getValue((Property)AbstractChunkLoaderBlock.ATTACHED)).booleanValue()) {
            BlockEntity be = this.getLevel().getBlockEntity(this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)DirectionalKineticBlock.FACING)).getOpposite()));
            if (!(be instanceof StationBlockEntity)) {
                return;
            }
            StationBlockEntity sbe = (StationBlockEntity)be;
            this.updateAttachedStation(sbe);
        } else if (!this.level.isClientSide()) {
            this.addToManager();
        }
    }

    public void reclaimChunks(Set<ChunkLoadManager.LoadedChunkPos> forcedChunks) {
        this.forcedChunks.addAll(forcedChunks);
    }

    public void tick() {
        boolean server;
        super.tick();
        boolean bl = server = (!this.level.isClientSide || this.isVirtual()) && this.level instanceof ServerLevel;
        if (!server) {
            this.spawnParticles();
        }
        if (server && this.chunkUpdateCooldown-- <= 0) {
            this.chunkUpdateCooldown = (Integer)CPLConfigs.server().getFor((LoaderType)this.type).chunkUpdateInterval.get();
            if (this.needsUpdate()) {
                this.setChanged();
                this.updateForcedChunks();
            }
        }
        if (server) {
            GlobalStation globalStation;
            if (this.deferredEdgePoint && (globalStation = this.attachedStation.getStation()) instanceof CPLGlobalStation) {
                CPLGlobalStation station = (CPLGlobalStation)globalStation;
                station.getLoader().addAttachment(this.type, this.getBlockPos());
                this.deferredEdgePoint = false;
            }
            boolean wasLoaderActive = this.isLoaderActive;
            boolean bl2 = this.isLoaderActive = StationChunkLoader.isEnabledForStation(this.type) && this.attachedStation != null && this.attachedStation.getStation() != null && this.attachedStation.getStation().getPresentTrain() != null;
            if (wasLoaderActive != this.isLoaderActive) {
                this.notifyUpdate();
            }
        }
    }

    private boolean needsUpdate() {
        if (this.lastBlockPos == null) {
            return true;
        }
        return !this.lastBlockPos.equals((Object)this.getBlockPos()) || this.lastEnabled != this.canLoadChunks() || this.lastRange != this.getLoadingRange() || this.chunkUnloadCooldown > 0;
    }

    protected void updateForcedChunks() {
        boolean resetStates = true;
        if (this.canLoadChunks()) {
            ChunkLoadManager.updateForcedChunks(this.level.getServer(), new ChunkLoadManager.LoadedChunkPos(this.getLevel(), this.getBlockPos()), this.getBlockPos(), this.getLoadingRange(), this.forcedChunks);
        } else if (this.chunkUnloadCooldown >= (Integer)CPLConfigs.server().getFor((LoaderType)this.type).unloadGracePeriod.get()) {
            ChunkLoadManager.unforceAllChunks(this.level.getServer(), this.getBlockPos(), this.forcedChunks);
        } else {
            this.chunkUnloadCooldown += ((Integer)CPLConfigs.server().getFor((LoaderType)this.type).chunkUpdateInterval.get()).intValue();
            resetStates = false;
        }
        if (resetStates) {
            this.chunkUnloadCooldown = 0;
            this.lastBlockPos = this.getBlockPos().immutable();
            this.lastEnabled = this.canLoadChunks();
            this.lastRange = this.getLoadingRange();
        }
    }

    public boolean canLoadChunks() {
        return this.isSpeedRequirementFulfilled() && (Boolean)CPLConfigs.server().getFor((LoaderType)this.type).enableStatic.get() != false;
    }

    public boolean isSpeedRequirementFulfilled() {
        if (!super.isSpeedRequirementFulfilled()) {
            return false;
        }
        BlockState state = this.getBlockState();
        if (!(this.getBlockState().getBlock() instanceof IRotate)) {
            return true;
        }
        IRotate def = (IRotate)state.getBlock();
        IRotate.SpeedLevel minimumRequiredSpeedLevel = def.getMinimumRequiredSpeedLevel();
        float minSpeed = minimumRequiredSpeedLevel.getSpeedValue();
        double requirement = (double)(minSpeed * (float)Math.pow(2.0, this.getLoadingRange())) * (Double)CPLConfigs.server().getFor((LoaderType)this.type).speedMultiplier.get();
        return (double)Math.abs(this.getSpeed()) >= requirement;
    }

    public void destroy() {
        boolean server;
        super.destroy();
        boolean bl = server = (!this.level.isClientSide || this.isVirtual()) && this.level instanceof ServerLevel;
        if (server) {
            ChunkLoadManager.unforceAllChunks(this.level.getServer(), this.getBlockPos(), this.forcedChunks);
        }
        this.updateAttachedStation(null);
        this.removeFromManager();
    }

    public void remove() {
        boolean server;
        super.remove();
        boolean bl = server = (!this.level.isClientSide || this.isVirtual()) && this.level instanceof ServerLevel;
        if (server) {
            ChunkLoadManager.unforceAllChunks(this.level.getServer(), this.getBlockPos(), this.forcedChunks);
        }
        this.updateAttachedStation(null);
        this.removeFromManager();
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.isLoaderActive = compound.getBoolean("CoreActive");
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putBoolean("CoreActive", this.isLoaderActive);
        super.write(compound, registries, clientPacket);
    }

    public abstract int getLoadingRange();

    protected void spawnParticles() {
        if (this.level == null) {
            return;
        }
        if (!this.canLoadChunks()) {
            return;
        }
        RandomSource r = this.level.getRandom();
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        if (r.nextInt(4) != 0) {
            return;
        }
        double speed = 0.0625;
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getNormal());
        Vec3 v2 = c.add(VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)r, (float)0.5f).multiply(1.0, 1.0, 1.0).normalize().scale(0.25 + r.nextDouble() * 0.125)).add(normal.scale(0.5));
        Vec3 motion = normal.scale(speed);
        this.level.addParticle((ParticleOptions)ParticleTypes.PORTAL, v2.x, v2.y, v2.z, motion.x, motion.y, motion.z);
    }
}

