/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.creategoggles.item.modifier;

import com.robocraft999.creategoggles.CreateGoggles;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemModifier {
    private final ResourceLocation name;
    private final Predicate<ItemStack> predicate;
    private final TagKey<Item> incompatibleItems;
    private List<ItemStack> cachedValidItems;

    public ItemModifier(String name, Predicate<ItemStack> predicate, TagKey<Item> incompatibleItems) {
        this.name = CreateGoggles.asResource(name);
        this.predicate = predicate;
        this.incompatibleItems = incompatibleItems;
    }

    public void apply(ItemStack stack) {
    }

    public TagKey<Item> getIncompatibleItems() {
        return this.incompatibleItems;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Component getHintComponent() {
        return Component.translatable((String)("hint.creategoggles.modifier." + this.getRegistryName().getPath())).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY});
    }

    public boolean isItemValid(ItemStack stack) {
        return !stack.is(this.getIncompatibleItems()) && this.predicate.test(stack);
    }

    public List<ItemStack> getValidItems() {
        if (this.cachedValidItems == null) {
            this.cachedValidItems = BuiltInRegistries.ITEM.stream().map(ItemStack::new).filter(this::isItemValid).toList();
        }
        return this.cachedValidItems;
    }

    public void clearCachedValidItems() {
        this.cachedValidItems = null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ItemModifier) {
            ItemModifier modifier = (ItemModifier)obj;
            return modifier.getRegistryName().equals((Object)this.getRegistryName());
        }
        return false;
    }
}

