/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util.biome;

import java.util.Map;
import me.pepperbell.continuity.client.ContinuityClient;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public final class BiomeHolder {
    private final ResourceLocation id;
    private Biome biome;

    BiomeHolder(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    @Nullable
    public Biome getBiome() {
        return this.biome;
    }

    void refresh(Registry<Biome> biomeRegistry, Map<ResourceLocation, ResourceLocation> compactIdMap) {
        ResourceLocation id = compactIdMap.get(this.id);
        if (id == null) {
            id = this.id;
        }
        if (biomeRegistry.containsKey(id)) {
            this.biome = (Biome)biomeRegistry.get(id);
        } else {
            ContinuityClient.LOGGER.warn("Unknown biome '" + String.valueOf(this.id) + "'");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BiomeHolder that = (BiomeHolder)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

