/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.compat.ftbteams.FTBTeamsCompat;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.TeamHandler;
import net.geforcemods.securitycraft.util.VanillaTeamHandler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class TeamUtils {
    private static List<TeamHandler> teamPrecedence;

    private TeamUtils() {
    }

    public static boolean areOnSameTeam(Owner owner1, Owner owner2) {
        if (owner1.equals(owner2)) {
            return true;
        }
        if (!((Boolean)ConfigHandler.SERVER.enableTeamOwnership.get()).booleanValue()) {
            return false;
        }
        for (TeamHandler teamHandler : teamPrecedence) {
            if (!teamHandler.areOnSameTeam(owner1, owner2)) continue;
            return true;
        }
        return false;
    }

    public static PlayerTeam getVanillaTeamFromPlayer(String playerName) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.getScoreboard().getPlayersTeam(playerName);
        }
        return ClientHandler.getClientPlayer().getScoreboard().getPlayersTeam(playerName);
    }

    public static TeamRepresentation getTeamRepresentation(Owner owner) {
        if (((Boolean)ConfigHandler.SERVER.enableTeamOwnership.get()).booleanValue()) {
            for (TeamHandler teamHandler : teamPrecedence) {
                TeamRepresentation teamRepresentation = teamHandler.getTeamRepresentation(owner);
                if (teamRepresentation == null) continue;
                return teamRepresentation;
            }
        }
        return null;
    }

    public static Collection<ServerPlayer> getOnlinePlayersFromOwner(MinecraftServer server, Owner owner) {
        if (((Boolean)ConfigHandler.SERVER.enableTeamOwnership.get()).booleanValue()) {
            for (TeamHandler teamHandler : teamPrecedence) {
                Collection<ServerPlayer> onlinePlayers = teamHandler.getOnlinePlayersFromOwner(server, owner);
                if (onlinePlayers == null || onlinePlayers.isEmpty()) continue;
                return onlinePlayers;
            }
        }
        return PlayerUtils.getPlayerListFromOwner(owner);
    }

    public static void setPrecedence(List<TeamHandler> list) {
        teamPrecedence = list;
    }

    public record TeamRepresentation(String name, int color) {
    }

    public static enum TeamType {
        FTB_TEAMS(() -> {
            if (ModList.get().isLoaded("ftbteams")) {
                return new FTBTeamsCompat();
            }
            return null;
        }),
        VANILLA(VanillaTeamHandler::new),
        NO_OP(() -> null);

        private final Supplier<TeamHandler> teamHandler;

        private TeamType(Supplier<TeamHandler> teamHandler) {
            this.teamHandler = teamHandler;
        }

        public TeamHandler getTeamHandler() {
            return this.teamHandler.get();
        }
    }
}

