/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.particle;

import net.geforcemods.securitycraft.SecurityCraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class FloorTrapCloudParticle
extends TextureSheetParticle {
    public FloorTrapCloudParticle(SpriteSet spriteSet, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z);
        this.setSize(0.01f, 0.01f);
        this.pickSprite(spriteSet);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.4f;
        this.hasPhysics = false;
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FloorTrapCloudParticle particle = new FloorTrapCloudParticle(this.spriteSet, level, x, y, z, SecurityCraft.RANDOM.nextGaussian() * 0.0075, 0.005, SecurityCraft.RANDOM.nextGaussian() * 0.0075);
            particle.lifetime = Mth.randomBetweenInclusive((RandomSource)level.random, (int)10, (int)40);
            particle.gravity = 0.0f;
            return particle;
        }
    }
}

