/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncSSSSettingsOnServer
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SyncSSSSettingsOnServer> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("sync_sss_settings_on_server"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncSSSSettingsOnServer> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SyncSSSSettingsOnServer>(){

        public SyncSSSSettingsOnServer decode(RegistryFriendlyByteBuf buf) {
            BlockPos pos = buf.readBlockPos();
            DataType dataType = (DataType)buf.readEnum(DataType.class);
            if (dataType == DataType.REMOVE_POS) {
                return new SyncSSSSettingsOnServer(pos, dataType, buf.readGlobalPos());
            }
            return new SyncSSSSettingsOnServer(pos, dataType);
        }

        public void encode(RegistryFriendlyByteBuf buf, SyncSSSSettingsOnServer packet) {
            buf.writeBlockPos(packet.pos);
            buf.writeEnum((Enum)packet.dataType);
            if (packet.dataType == DataType.REMOVE_POS) {
                buf.writeGlobalPos(packet.posToRemove);
            }
        }
    };
    private BlockPos pos;
    private DataType dataType;
    private GlobalPos posToRemove;

    public SyncSSSSettingsOnServer() {
    }

    public SyncSSSSettingsOnServer(BlockPos pos, DataType dataType) {
        this(pos, dataType, null);
    }

    public SyncSSSSettingsOnServer(BlockPos pos, DataType dataType, GlobalPos posToRemove) {
        this.pos = pos;
        this.dataType = dataType;
        this.posToRemove = posToRemove;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        SonicSecuritySystemBlockEntity sss;
        BlockEntity blockEntity;
        Player player = ctx.player();
        Level level = player.level();
        if (!player.isSpectator() && (blockEntity = level.getBlockEntity(this.pos)) instanceof SonicSecuritySystemBlockEntity && (sss = (SonicSecuritySystemBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            switch (this.dataType.ordinal()) {
                case 0: {
                    sss.setActive(true);
                    break;
                }
                case 1: {
                    sss.setActive(false);
                    if (!sss.isRecording()) break;
                    sss.setRecording(false);
                    break;
                }
                case 2: {
                    sss.setPings(true);
                    break;
                }
                case 3: {
                    sss.setPings(false);
                    break;
                }
                case 4: {
                    sss.setRecording(true);
                    break;
                }
                case 5: {
                    sss.setRecording(false);
                    break;
                }
                case 6: {
                    sss.clearNotes();
                    break;
                }
                case 7: {
                    sss.delink(this.posToRemove, false);
                    break;
                }
                case 8: {
                    sss.setDisableBlocksWhenTuneIsPlayed(!sss.disablesBlocksWhenTuneIsPlayed());
                }
            }
            sss.setChanged();
        }
    }

    public static enum DataType {
        POWER_ON,
        POWER_OFF,
        SOUND_ON,
        SOUND_OFF,
        RECORDING_ON,
        RECORDING_OFF,
        CLEAR_NOTES,
        REMOVE_POS,
        INVERT_FUNCTIONALITY;

    }
}

