/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.components.NamedPositions;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RemoveSentryFromSRAT(GlobalPos globalPos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RemoveSentryFromSRAT> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("remove_sentry_from_srat"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RemoveSentryFromSRAT> STREAM_CODEC = StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, RemoveSentryFromSRAT::globalPos, RemoveSentryFromSRAT::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        NamedPositions sentries;
        Player player = ctx.player();
        ItemStack stack = PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get());
        if (!player.isSpectator() && !stack.isEmpty() && (sentries = (NamedPositions)stack.get(SCContent.BOUND_SENTRIES)) != null) {
            sentries.remove(SCContent.BOUND_SENTRIES, stack, this.globalPos);
        }
    }
}

