/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class SecurityCameraModel
extends EntityModel<SecurityCamera> {
    public static final float DEFAULT_X_ROT = 0.2617994f;
    private ModelPart attachment;
    private ModelPart stickTop;
    private ModelPart cameraRotationPoint1;
    public final ModelPart cameraRotationPoint2;

    public SecurityCameraModel(ModelPart modelPart) {
        this.attachment = modelPart.getChild("attachment");
        this.stickTop = modelPart.getChild("stick_top");
        this.stickTop.xRot = -0.5235988f;
        this.cameraRotationPoint1 = this.setUpRotationPoint(modelPart, "camera_rotation_point_1", "camera_body");
        this.cameraRotationPoint2 = this.setUpRotationPoint(modelPart, "camera_rotation_point_2", "camera_lens");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition rootDefinition = meshDefinition.getRoot();
        PartDefinition stickTopDefinition = rootDefinition.addOrReplaceChild("stick_top", CubeListBuilder.create().texOffs(2, 12).addBox(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 6.0f), PartPose.offset((float)-1.0f, (float)13.75f, (float)2.25f));
        PartDefinition cameraRotationPoint1Definition = SecurityCameraModel.defineRotationPoint(rootDefinition, "camera_rotation_point_1");
        PartDefinition cameraRotationPoint2Definition = SecurityCameraModel.defineRotationPoint(rootDefinition, "camera_rotation_point_2");
        PartDefinition cameraBodyDefinition = cameraRotationPoint1Definition.addOrReplaceChild("camera_body", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 8.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)-5.0f));
        rootDefinition.addOrReplaceChild("attachment", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 6.0f, 6.0f, 1.0f), PartPose.offset((float)-3.0f, (float)13.0f, (float)7.0f));
        stickTopDefinition.addOrReplaceChild("stick_bottom", CubeListBuilder.create().texOffs(1, 12).addBox(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 7.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        cameraBodyDefinition.addOrReplaceChild("camera_lens_right", CubeListBuilder.create().texOffs(10, 40).addBox(-2.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)3.0f, (float)0.0f, (float)-3.0f));
        cameraBodyDefinition.addOrReplaceChild("camera_lens_left", CubeListBuilder.create().texOffs(0, 40).addBox(0.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)-2.0f, (float)0.0f, (float)-3.0f));
        cameraBodyDefinition.addOrReplaceChild("camera_lens_top", CubeListBuilder.create().texOffs(20, 40).addBox(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f), PartPose.offset((float)-1.0f, (float)0.0f, (float)-3.0f));
        cameraRotationPoint2Definition.addOrReplaceChild("camera_lens", CubeListBuilder.create().texOffs(0, 50).addBox(-1.99f, 0.01f, -2.01f, 3.98f, 2.98f, 0.01f), PartPose.offset((float)0.0f, (float)0.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    private static PartDefinition defineRotationPoint(PartDefinition parent, String name) {
        return parent.addOrReplaceChild(name, CubeListBuilder.create().texOffs(0, 25).addBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.offset((float)0.0f, (float)14.0f, (float)3.0f));
    }

    public void renderToBuffer(PoseStack pose, VertexConsumer builder, int packedLight, int packedOverlay, int packedARGB) {
        this.attachment.render(pose, builder, packedLight, packedOverlay);
        this.stickTop.render(pose, builder, packedLight, packedOverlay);
        this.cameraRotationPoint1.render(pose, builder, packedLight, packedOverlay);
        this.cameraRotationPoint2.render(pose, builder, packedLight, packedOverlay, packedARGB);
    }

    public void setupAnim(SecurityCamera entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void rotateCameraX(float rot) {
        this.cameraRotationPoint1.xRot = rot;
        this.cameraRotationPoint2.xRot = rot;
    }

    public void rotateCameraY(float rot) {
        this.cameraRotationPoint1.yRot = rot;
        this.cameraRotationPoint2.yRot = rot;
    }

    private ModelPart setUpRotationPoint(ModelPart modelPart, String name, String child) {
        ModelPart rotationPoint = modelPart.getChild(name);
        rotationPoint.xRot = 0.2617994f;
        rotationPoint.getChild((String)child).xRot = 0.2617994f;
        return rotationPoint;
    }
}

