/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import java.util.Optional;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.components.NamedPositions;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;

public class SentryRemoteAccessToolItem
extends Item {
    public static final int MAX_SENTRIES = 12;
    public static final NamedPositions DEFAULT_NAMED_POSITIONS = NamedPositions.sized(12);

    public SentryRemoteAccessToolItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            SentryRemoteAccessToolItem.updateComponentWithNames(stack, level);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new OpenScreen(OpenScreen.DataType.SENTRY_REMOTE_ACCESS_TOOL), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        List sentries = level.getEntitiesOfClass(Sentry.class, new AABB(pos));
        ItemStack stack = ctx.getItemInHand();
        if (!sentries.isEmpty()) {
            Sentry sentry = (Sentry)sentries.get(0);
            BlockPos sentryPos = sentry.blockPosition();
            if (!sentry.isOwnedBy((Entity)player)) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SentryRemoteAccessToolItem)((Object)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:srat.cantBind", new Object[0]), ChatFormatting.RED);
                return InteractionResult.FAIL;
            }
            NamedPositions positions = (NamedPositions)stack.get(SCContent.BOUND_SENTRIES);
            if (positions != null) {
                GlobalPos globalPos = new GlobalPos(level.dimension(), pos);
                if (positions.remove(SCContent.BOUND_SENTRIES, stack, globalPos)) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SentryRemoteAccessToolItem)((Object)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:srat.unbound", sentryPos), ChatFormatting.RED);
                } else if (positions.add(SCContent.BOUND_SENTRIES, stack, globalPos, sentry.hasCustomName() ? Optional.of(sentry.getCustomName().getString()) : Optional.empty())) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SentryRemoteAccessToolItem)((Object)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:srat.bound", sentryPos), ChatFormatting.GREEN);
                } else {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SentryRemoteAccessToolItem)((Object)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:srat.noSlots", new Object[0]), ChatFormatting.RED);
                    return InteractionResult.FAIL;
                }
                return InteractionResult.SUCCESS;
            }
        } else if (!level.isClientSide) {
            SentryRemoteAccessToolItem.updateComponentWithNames(stack, level);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new OpenScreen(OpenScreen.DataType.SENTRY_REMOTE_ACCESS_TOOL), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        NamedPositions positions = (NamedPositions)stack.get(SCContent.BOUND_SENTRIES);
        if (positions != null && !positions.isEmpty()) {
            List<NamedPositions.Entry> entries = positions.positions();
            for (int i = 0; i < 12; ++i) {
                List sentries;
                NamedPositions.Entry entry = entries.get(i);
                if (entry == null) {
                    tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "---")));
                    continue;
                }
                BlockPos pos = entry.globalPos().pos();
                String nameToShow = null;
                nameToShow = entry.name().isPresent() ? entry.name().get() : (!(sentries = Minecraft.getInstance().player.level().getEntitiesOfClass(Sentry.class, new AABB(pos))).isEmpty() && ((Sentry)sentries.get(0)).hasCustomName() ? ((Sentry)sentries.get(0)).getCustomName().getString() : Utils.localize("tooltip.securitycraft:sentry", i).getString());
                tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + nameToShow + ": " + Utils.getFormattedCoordinates(pos).getString())));
            }
        }
    }

    public static void updateComponentWithNames(ItemStack stack, Level level) {
        NamedPositions.updateComponentWithNames(SCContent.BOUND_SENTRIES, stack, entry -> {
            List sentries;
            GlobalPos globalPos = entry.globalPos();
            if (level.dimension().equals(globalPos.dimension()) && level.isLoaded(globalPos.pos()) && !(sentries = level.getEntitiesOfClass(Sentry.class, new AABB(globalPos.pos()))).isEmpty()) {
                return (Nameable)sentries.get(0);
            }
            return null;
        });
    }
}

