/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class OwnerRestrictedSlot
extends Slot {
    private final IOwnable ownable;
    private final boolean isGhostSlot;

    public OwnerRestrictedSlot(Container inventory, IOwnable ownable, int index, int xPos, int yPos, boolean ghostSlot) {
        super(inventory, index, xPos, yPos);
        this.ownable = ownable;
        this.isGhostSlot = ghostSlot;
    }

    public boolean mayPickup(Player player) {
        return this.ownable.isOwnedBy((Entity)player) && !this.isGhostSlot;
    }

    public boolean mayPlace(ItemStack stack) {
        return !this.isGhostSlot;
    }

    public void set(ItemStack stack) {
        if (this.mayPlace(stack)) {
            this.container.setItem(this.getSlotIndex(), stack);
            this.setChanged();
        }
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isGhostSlot() {
        return this.isGhostSlot;
    }
}

