/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.item.ItemStack;

public record PasscodeData(String passcode, UUID saltKey) {
    public static final Codec<PasscodeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("passcode").forGetter(PasscodeData::passcode), (App)UUIDUtil.CODEC.fieldOf("salt_key").forGetter(PasscodeData::saltKey)).apply((Applicative)instance, PasscodeData::new));

    public void checkPasscode(ItemStack stack, String codeToCheck, Runnable ifTrue) {
        byte[] salt = SaltData.getSalt(this.saltKey);
        if (salt == null) {
            stack.remove(SCContent.PASSCODE_DATA);
            return;
        }
        PasscodeUtils.hashPasscode(codeToCheck, salt, hashedCode -> {
            if (Arrays.equals(PasscodeUtils.stringToBytes(this.passcode), hashedCode)) {
                ifTrue.run();
            }
        });
    }

    public static void hashAndSetPasscode(ItemStack stack, String passcode, Consumer<PasscodeData> afterSet) {
        byte[] salt = PasscodeUtils.generateSalt();
        UUID saltKey = SaltData.putSalt(salt);
        PasscodeUtils.hashPasscode(passcode, salt, hashedCode -> {
            PasscodeData passcodeData = new PasscodeData(PasscodeUtils.bytesToString(hashedCode), saltKey);
            stack.set(SCContent.PASSCODE_DATA, (Object)passcodeData);
            afterSet.accept(passcodeData);
        });
    }
}

