/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;

public record ListModuleData(List<String> players, List<String> teams, boolean affectEveryone) implements TooltipProvider
{
    public static final int MAX_PLAYERS = 50;
    public static final ListModuleData EMPTY = new ListModuleData(List.of(), List.of(), false);
    public static final Codec<ListModuleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.sizeLimitedListOf(50).fieldOf("players").forGetter(ListModuleData::players), (App)Codec.STRING.listOf().fieldOf("teams").forGetter(ListModuleData::teams), (App)Codec.BOOL.fieldOf("affect_everyone").forGetter(ListModuleData::affectEveryone)).apply((Applicative)instance, ListModuleData::new));
    public static final StreamCodec<ByteBuf, ListModuleData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list((int)50)), ListModuleData::players, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), ListModuleData::teams, (StreamCodec)ByteBufCodecs.BOOL, ListModuleData::affectEveryone, ListModuleData::new);

    public ListModuleData addPlayer(ItemStack stack, String playerName) {
        if (this.players.size() == 50 || this.isPlayerOnList(playerName)) {
            return this;
        }
        ArrayList<String> newPlayers = new ArrayList<String>(this.players);
        newPlayers.add(playerName);
        ListModuleData newListModuleData = new ListModuleData(newPlayers, this.teams, this.affectEveryone);
        stack.set(SCContent.LIST_MODULE_DATA, (Object)newListModuleData);
        return newListModuleData;
    }

    public ListModuleData removePlayer(ItemStack stack, String playerName) {
        if (this.players.isEmpty() || !this.isPlayerOnList(playerName)) {
            return this;
        }
        ArrayList<String> newPlayers = new ArrayList<String>(this.players);
        newPlayers.remove(playerName);
        ListModuleData newListModuleData = new ListModuleData(newPlayers, this.teams, this.affectEveryone);
        stack.set(SCContent.LIST_MODULE_DATA, (Object)newListModuleData);
        return newListModuleData;
    }

    public ListModuleData toggleTeam(ItemStack stack, String teamName) {
        ArrayList<String> newTeams = new ArrayList<String>(this.teams);
        if (this.isTeamOnList(teamName)) {
            newTeams.remove(teamName);
        } else {
            newTeams.add(teamName);
        }
        ListModuleData newListModuleData = new ListModuleData(this.players, newTeams, this.affectEveryone);
        stack.set(SCContent.LIST_MODULE_DATA, (Object)newListModuleData);
        return newListModuleData;
    }

    public boolean isTeamOfPlayerOnList(Level level, String playerName) {
        PlayerTeam team = level.getScoreboard().getPlayersTeam(playerName);
        return team != null && this.isTeamOnList(team.getName());
    }

    public boolean isTeamOnList(String teamName) {
        return this.teams.contains(teamName);
    }

    public boolean isPlayerOnList(String playerName) {
        return this.players.stream().anyMatch(playerName::equalsIgnoreCase);
    }

    public void updateAffectEveryone(ItemStack stack, boolean newAffectEveryone) {
        if (newAffectEveryone != this.affectEveryone) {
            stack.set(SCContent.LIST_MODULE_DATA, (Object)new ListModuleData(this.players, this.teams, newAffectEveryone));
        }
    }

    public void addToTooltip(Item.TooltipContext ctx, Consumer<Component> lineAdder, TooltipFlag flag) {
        if (this.affectEveryone) {
            lineAdder.accept((Component)Utils.localize("tooltip.securitycraft.component.list_module_data.affects_everyone", new Object[0]).setStyle(Utils.GRAY_STYLE));
        } else {
            lineAdder.accept((Component)Utils.localize("tooltip.securitycraft.component.list_module_data.added_players", this.players.size()).setStyle(Utils.GRAY_STYLE));
            lineAdder.accept((Component)Utils.localize("tooltip.securitycraft.component.list_module_data.added_teams", this.teams.size()).setStyle(Utils.GRAY_STYLE));
        }
    }
}

