/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.stream.Stream;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.ClaymoreBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClaymoreBlock
extends ExplosiveBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty DEACTIVATED = BooleanProperty.create((String)"deactivated");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape NORTH = Stream.of(Block.box((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)6.0, (double)9.0), Block.box((double)5.0, (double)0.0, (double)7.0, (double)11.0, (double)6.0, (double)8.0), Block.box((double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)7.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape EAST = Stream.of(Block.box((double)7.0, (double)0.0, (double)4.0, (double)8.0, (double)6.0, (double)12.0), Block.box((double)8.0, (double)0.0, (double)5.0, (double)9.0, (double)6.0, (double)11.0), Block.box((double)7.0, (double)6.0, (double)6.0, (double)8.0, (double)7.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SOUTH = Stream.of(Block.box((double)4.0, (double)0.0, (double)7.0, (double)12.0, (double)6.0, (double)8.0), Block.box((double)5.0, (double)0.0, (double)8.0, (double)11.0, (double)6.0, (double)9.0), Block.box((double)6.0, (double)6.0, (double)7.0, (double)10.0, (double)7.0, (double)8.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape WEST = Stream.of(Block.box((double)8.0, (double)0.0, (double)4.0, (double)9.0, (double)6.0, (double)12.0), Block.box((double)7.0, (double)0.0, (double)5.0, (double)8.0, (double)6.0, (double)11.0), Block.box((double)8.0, (double)6.0, (double)6.0, (double)9.0, (double)7.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public ClaymoreBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        ClaymoreBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ClaymoreBlockEntity && (be = (ClaymoreBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            if (!level.isClientSide) {
                player.openMenu((MenuProvider)be);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        if (level.getBlockState(pos.below()).isAir()) {
            level.destroyBlock(pos, true);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return BlockUtils.isSideSolid(level, pos.below(), Direction.UP);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        ClaymoreBlockEntity claymore;
        BlockEntity blockEntity;
        if (!(player.isCreative() || level.isClientSide || ((Boolean)level.getBlockState(pos).getValue((Property)DEACTIVATED)).booleanValue() || !((blockEntity = level.getBlockEntity(pos)) instanceof ClaymoreBlockEntity) || !(claymore = (ClaymoreBlockEntity)blockEntity).getTargetingMode().allowsPlayers() || claymore.isOwnedBy((Entity)player) && claymore.ignoresOwner())) {
            this.explode(level, pos);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosion) {
        if (!level.isClientSide && level.getBlockState(pos).hasProperty((Property)DEACTIVATED) && !((Boolean)level.getBlockState(pos).getValue((Property)DEACTIVATED)).booleanValue()) {
            if (pos.equals((Object)BlockPos.containing((Position)explosion.center()))) {
                return;
            }
            this.explode(level, pos);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
    }

    @Override
    public boolean activateMine(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (((Boolean)state.getValue((Property)DEACTIVATED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (!((Boolean)state.getValue((Property)DEACTIVATED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    @Override
    public void explode(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            level.destroyBlock(pos, false);
            level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 1.5f : 3.5f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionInteraction());
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof ClaymoreBlockEntity) {
            ClaymoreBlockEntity be = (ClaymoreBlockEntity)blockEntity;
            if (!((Boolean)ConfigHandler.SERVER.vanillaToolBlockBreaking.get()).booleanValue()) {
                be.dropAllModules();
            }
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)be.getLensContainer());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            default -> Shapes.block();
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, DEACTIVATED, WATERLOGGED});
    }

    @Override
    public boolean isActive(Level level, BlockPos pos) {
        return (Boolean)level.getBlockState(pos).getValue((Property)DEACTIVATED) == false;
    }

    @Override
    public boolean explodesWhenInteractedWith() {
        return false;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ClaymoreBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : ClaymoreBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.CLAYMORE_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

