/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.UUID;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.NamedBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.SpecialDoorBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadDoorBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class KeypadDoorBlockEntity
extends SpecialDoorBlockEntity
implements IPasscodeProtected {
    private Option.BooleanOption sendAllowlistMessage = new Option.SendAllowlistMessageOption(false);
    private Option.BooleanOption sendDenylistMessage = new Option.SendDenylistMessageOption(true);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption();
    private long cooldownEnd = 0L;
    private byte[] passcode;
    private UUID saltKey;
    private boolean saveSalt = false;

    public KeypadDoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEYPAD_DOOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        long cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis();
        this.savePasscodeAndSalt(tag);
        tag.putLong("cooldownLeft", cooldownLeft <= 0L ? -1L : cooldownLeft);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.loadSaltKey(tag);
        this.loadPasscode(tag);
        this.cooldownEnd = System.currentTimeMillis() + tag.getLong("cooldownLeft");
        if (tag.contains("sendMessage") && !tag.getBoolean("sendMessage")) {
            this.sendAllowlistMessage.setValue(false);
            this.sendDenylistMessage.setValue(false);
        }
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.level.isClientSide && (block = this.getBlockState().getBlock()) instanceof KeypadDoorBlock) {
            KeypadDoorBlock block2 = (KeypadDoorBlock)block;
            block2.activate(this.getBlockState(), this.level, this.worldPosition, player, this.getSignalLength());
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(Player player) {
        if (this.isDisabled()) {
            player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return (Boolean)this.getBlockState().getValue((Property)DoorBlock.OPEN) == false && IPasscodeProtected.super.shouldAttemptCodebreak(player);
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
        this.setChanged();
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
        this.setChanged();
    }

    @Override
    public void setSaveSalt(boolean saveSalt) {
        this.saveSalt = saveSalt;
    }

    @Override
    public boolean shouldSaveSalt() {
        return this.saveSalt;
    }

    @Override
    public void setPasscodeInAdjacentBlock(String codeToSet) {
        this.runForOtherHalf(otherBe -> {
            if (this.getOwner().owns((IOwnable)otherBe)) {
                otherBe.hashAndSetPasscode(codeToSet, this.getSalt());
                this.level.sendBlockUpdated(otherBe.getBlockPos(), otherBe.getBlockState(), otherBe.getBlockState(), 2);
            }
        });
    }

    @Override
    public void startCooldown() {
        long start = System.currentTimeMillis();
        this.startCooldown(start);
        this.runForOtherHalf(otherHalf -> otherHalf.startCooldown(start));
    }

    public void startCooldown(long start) {
        if (!this.isOnCooldown()) {
            this.cooldownEnd = start + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
            this.setChanged();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendAllowlistMessage, this.sendDenylistMessage, this.signalLength, this.disabled, this.smartModuleCooldown};
    }

    public boolean sendsAllowlistMessage() {
        return (Boolean)this.sendAllowlistMessage.get();
    }

    public boolean sendsDenylistMessage() {
        return (Boolean)this.sendDenylistMessage.get();
    }

    @Override
    public int defaultSignalLength() {
        return 60;
    }

    @Override
    public void setCustomName(Component customName) {
        super.setCustomName(customName);
        if (this.getBlockState().getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            ((NamedBlockEntity)this.level.getBlockEntity(this.worldPosition.above())).setCustomName(customName);
        }
    }

    public void runForOtherHalf(Consumer<KeypadDoorBlockEntity> action) {
        BlockEntity be = null;
        if (this.level == null) {
            return;
        }
        if (this.getBlockState().getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER) {
            be = this.level.getBlockEntity(this.worldPosition.above());
        } else if (this.getBlockState().getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.UPPER) {
            be = this.level.getBlockEntity(this.worldPosition.below());
        }
        if (be instanceof KeypadDoorBlockEntity) {
            KeypadDoorBlockEntity otherHalf = (KeypadDoorBlockEntity)be;
            action.accept(otherHalf);
        }
    }
}

