/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import net.neoforged.neoforge.network.PacketDistributor;

public class DisguisableBlockEntity
extends CustomizableBlockEntity {
    public DisguisableBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)SCContent.DISGUISABLE_BLOCK_ENTITY.get(), pos, state);
    }

    public DisguisableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleInserted(this, stack, toggled);
        }
    }

    public static void onDisguiseModuleInserted(BlockEntity be, ItemStack stack, boolean toggled) {
        AuxiliaryLightManager lightManager;
        BlockState state = be.getBlockState();
        Level level = be.getLevel();
        BlockPos worldPosition = be.getBlockPos();
        int newLight = IDisguisable.getDisguisedBlockStateFromStack(stack).map(s -> s.getLightEmission((BlockGetter)level, worldPosition)).orElse(0);
        if (!level.isClientSide) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(worldPosition), (CustomPacketPayload)new RefreshDisguisableModel(worldPosition, true, stack, toggled), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                level.scheduleTick(worldPosition, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
                level.updateNeighborsAt(worldPosition, state.getBlock());
            }
        } else {
            ClientHandler.putDisguisedBeRenderer(be, stack);
        }
        if (newLight > 0 && (lightManager = level.getAuxLightManager(worldPosition)) != null) {
            lightManager.setLightAt(worldPosition, newLight);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleRemoved(this, stack, toggled);
        }
    }

    public static void onDisguiseModuleRemoved(BlockEntity be, ItemStack stack, boolean toggled) {
        BlockState state = be.getBlockState();
        Level level = be.getLevel();
        BlockPos worldPosition = be.getBlockPos();
        if (!level.isClientSide) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(worldPosition), (CustomPacketPayload)new RefreshDisguisableModel(worldPosition, false, stack, toggled), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                level.scheduleTick(worldPosition, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
                level.updateNeighborsAt(worldPosition, state.getBlock());
            }
        } else {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(be);
        }
        IDisguisable.getDisguisedBlockStateFromStack(stack).ifPresent(disguisedState -> {
            if (disguisedState.getLightEmission((BlockGetter)level, worldPosition) > 0) {
                level.getAuxLightManager(worldPosition).removeLightAt(worldPosition);
            }
        });
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, packet, lookupProvider);
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    public void onLoad() {
        super.onLoad();
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    public static <T extends BlockEntity> void onHandleUpdateTag(T be) {
        Level level = be.getLevel();
        if (level != null && level.isClientSide) {
            ItemStack stack = ((IModuleInventory)be).getModule(ModuleType.DISGUISE);
            if (!stack.isEmpty()) {
                ClientHandler.putDisguisedBeRenderer(be, stack);
            } else {
                ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(be);
            }
            ClientHandler.refreshModelData(be);
        }
    }

    public void setRemoved() {
        super.setRemoved();
        DisguisableBlockEntity.onSetRemoved(this);
    }

    public static void onSetRemoved(BlockEntity be) {
        if (be.getLevel().isClientSide) {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(be);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[0];
    }

    public ModelData getModelData() {
        return DisguisableBlockEntity.getModelData(this);
    }

    public static ModelData getModelData(BlockEntity be) {
        return DisguisableBlockEntity.getModelDataBuilder(be).build();
    }

    public static ModelData.Builder getModelDataBuilder(BlockEntity be) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(be).orElse(Blocks.AIR.defaultBlockState());
        return ModelData.builder().with(DisguisableDynamicBakedModel.DISGUISED_STATE, (Object)disguisedState);
    }
}

