/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.datagen.tag;

import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.storage.FluidStorageVariant;
import com.refinedmods.refinedstorage.common.storage.ItemStorageVariant;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockTagsProvider
extends TagsProvider<Block> {
    public static final TagKey<Block> MINEABLE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mineable/pickaxe"));

    public BlockTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> providerCompletableFuture, @Nullable ExistingFileHelper existingFileHelper) {
        super(packOutput, Registries.BLOCK, providerCompletableFuture, "refinedstorage", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.markAsMineable(Blocks.INSTANCE.getCable());
        this.markAsMineable(Blocks.INSTANCE.getDiskDrive());
        this.markAsMineable(Blocks.INSTANCE.getMachineCasing());
        this.markAsMineable(Blocks.INSTANCE.getGrid());
        this.markAsMineable(Blocks.INSTANCE.getCraftingGrid());
        this.markAsMineable(Blocks.INSTANCE.getPatternGrid());
        this.markAsMineable(Blocks.INSTANCE.getController());
        this.markAsMineable(Blocks.INSTANCE.getCreativeController());
        for (ItemStorageVariant itemStorageVariant : ItemStorageVariant.values()) {
            this.markAsMineable(Blocks.INSTANCE.getItemStorageBlock(itemStorageVariant));
        }
        for (Enum enum_ : FluidStorageVariant.values()) {
            this.markAsMineable(Blocks.INSTANCE.getFluidStorageBlock((FluidStorageVariant)enum_));
        }
        this.markAsMineable(Blocks.INSTANCE.getImporter());
        this.markAsMineable(Blocks.INSTANCE.getExporter());
        this.markAsMineable(Blocks.INSTANCE.getInterface());
        this.markAsMineable(Blocks.INSTANCE.getExternalStorage());
        this.markAsMineable(Blocks.INSTANCE.getDetector());
        this.markAsMineable(Blocks.INSTANCE.getDestructor());
        this.markAsMineable(Blocks.INSTANCE.getConstructor());
        this.markAsMineable(Blocks.INSTANCE.getWirelessTransmitter());
        this.markAsMineable(Blocks.INSTANCE.getStorageMonitor());
        this.markAsMineable(Blocks.INSTANCE.getNetworkReceiver());
        this.markAsMineable(Blocks.INSTANCE.getNetworkTransmitter());
        this.markAsMineable(Blocks.INSTANCE.getPortableGrid());
        this.markAsMineable(Blocks.INSTANCE.getCreativePortableGrid());
        this.markAsMineable(Blocks.INSTANCE.getSecurityManager());
        this.markAsMineable(Blocks.INSTANCE.getRelay());
        this.markAsMineable(Blocks.INSTANCE.getDiskInterface());
        this.markAsMineable(Blocks.INSTANCE.getAutocrafter());
        this.markAsMineable(Blocks.INSTANCE.getAutocrafterManager());
        this.markAsMineable(Blocks.INSTANCE.getAutocraftingMonitor());
    }

    private void markAsMineable(BlockColorMap<?, ?> map) {
        this.tag(MINEABLE).addAll(map.values().stream().map(b -> ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)BuiltInRegistries.BLOCK.getKey(b))).toList());
    }

    private void markAsMineable(Block block) {
        this.tag(MINEABLE).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)block)));
    }
}

