/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.refinedmods.refinedstorage.api.storage.StorageState;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.render.CubeBuilder;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AbstractDiskLedBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    protected void renderLed(PoseStack poseStack, VertexConsumer vertexConsumer, int x, int y, int z, Disk disk, Direction excludeDirection) {
        if (disk.state() == StorageState.NONE) {
            return;
        }
        int color = this.getColor(disk.state());
        CubeBuilder.putCube(poseStack, vertexConsumer, (float)x / 16.0f, (float)y / 16.0f, (float)z / 16.0f, (float)(x + 1) / 16.0f, (float)(y + 1) / 16.0f, (float)(z + 1) / 16.0f, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255, excludeDirection);
    }

    private int getColor(StorageState state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case StorageState.NONE -> 0;
            case StorageState.INACTIVE -> 0x323232;
            case StorageState.NORMAL -> 59903;
            case StorageState.NEAR_CAPACITY -> 16758528;
            case StorageState.FULL -> 14306112;
        };
    }

    protected static void rotate(PoseStack poseStack, BiDirection direction) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(direction.getQuaternion());
        poseStack.translate(-0.5f, -0.5f, -0.5f);
    }

    protected static void postRotate(PoseStack poseStack) {
        poseStack.popPose();
    }
}

