/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.autocrafting.PatternResolver;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

class SmithingTablePatternClientTooltipComponent
implements ClientTooltipComponent {
    private static final int ARROW_SPACING = 8;
    private final Component outputText;
    private final PatternResolver.ResolvedSmithingTablePattern pattern;

    SmithingTablePatternClientTooltipComponent(PatternResolver.ResolvedSmithingTablePattern pattern) {
        this.outputText = SmithingTablePatternClientTooltipComponent.getOutputText(pattern.output());
        this.pattern = pattern;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        graphics.drawString(font, this.outputText, x, y, 0xAAAAAA);
        int slotsY = y + 9 + 2;
        graphics.blitSprite(Sprites.SLOT, x, slotsY, 18, 18);
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(ItemResource.class);
        rendering.render(this.pattern.template(), graphics, x + 1, slotsY + 1);
        graphics.blitSprite(Sprites.SLOT, x + 18, slotsY, 18, 18);
        rendering.render(this.pattern.base(), graphics, x + 18 + 1, slotsY + 1);
        graphics.blitSprite(Sprites.SLOT, x + 18 + 18, slotsY, 18, 18);
        rendering.render(this.pattern.addition(), graphics, x + 18 + 18 + 1, slotsY + 1);
        graphics.blitSprite(Sprites.LIGHT_ARROW, x + 54 + 8, y + 9 + 2 + 9 - 7, 22, 15);
        int lastSlotX = x + 54 + 8 + 22 + 8;
        graphics.blitSprite(Sprites.SLOT, lastSlotX, slotsY, 18, 18);
        rendering.render(this.pattern.output(), graphics, lastSlotX + 1, slotsY + 1);
    }

    public int getHeight() {
        return 32;
    }

    public int getWidth(Font font) {
        return Math.max(font.width((FormattedText)this.outputText), 110);
    }

    private static Component getOutputText(ItemResource output) {
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(ItemResource.class);
        return Component.literal((String)"1x ").append(rendering.getDisplayName(output)).withStyle(ChatFormatting.GRAY);
    }
}

