/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.api.support.energy;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.energy.AbstractEnergyItem;
import com.refinedmods.refinedstorage.common.api.support.energy.EnergyItemHelper;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemContext;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemHelper;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReferenceHandlerItem;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.3.1")
public abstract class AbstractNetworkEnergyItem
extends AbstractEnergyItem
implements SlotReferenceHandlerItem {
    protected final NetworkItemHelper networkItemHelper;

    protected AbstractNetworkEnergyItem(Item.Properties properties, EnergyItemHelper energyItemHelper, NetworkItemHelper networkItemHelper) {
        super(properties, energyItemHelper);
        this.networkItemHelper = networkItemHelper;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        return this.networkItemHelper.bind(ctx);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return this.networkItemHelper.getTooltipImage(stack);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        this.networkItemHelper.addTooltip(stack, tooltip);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level.getServer() != null) {
                SlotReference slotReference = RefinedStorageApi.INSTANCE.createInventorySlotReference(player, hand);
                slotReference.resolve(player).ifPresent(s -> this.use(serverPlayer, (ItemStack)s, slotReference));
            }
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    @Override
    public void use(ServerPlayer player, ItemStack stack, SlotReference slotReference) {
        NetworkItemContext context = RefinedStorageApi.INSTANCE.getNetworkItemHelper().createContext(stack, player, slotReference);
        this.use((Component)stack.get(DataComponents.CUSTOM_NAME), player, slotReference, context);
    }

    protected abstract void use(@Nullable Component var1, ServerPlayer var2, SlotReference var3, NetworkItemContext var4);

    public boolean isBound(ItemStack stack) {
        return this.networkItemHelper.isBound(stack);
    }
}

