/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.network;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import win.demistorm.Platform;
import win.demistorm.VRThrowingExtensions;

public class TNTServer {
    private static TNTServer instance;
    private final Map<ServerPlayer, Integer> tntTimers = new HashMap<ServerPlayer, Integer>();
    private static final int TNT_FUSE_TICKS = 100;
    private static final float EXPLOSION_POWER = 4.0f;

    private TNTServer() {
    }

    public static TNTServer instance() {
        if (instance == null) {
            instance = new TNTServer();
        }
        return instance;
    }

    public void startTNTTimer(ServerPlayer player) {
        if (player == null || !player.isAlive()) {
            return;
        }
        this.tntTimers.put(player, 100);
        VRThrowingExtensions.log.debug("[TNTServer] Started {}-tick fuse timer for {}", (Object)100, (Object)player.getName().getString());
    }

    public void cancelTNTTimer(ServerPlayer player) {
        if (this.tntTimers.remove(player) != null) {
            VRThrowingExtensions.log.debug("[TNTServer] Cancelled fuse timer for {}", (Object)player.getName().getString());
        }
    }

    public int getRemainingTicks(ServerPlayer player) {
        return this.tntTimers.getOrDefault(player, 0);
    }

    public boolean hasActiveTimer(ServerPlayer player) {
        return this.tntTimers.containsKey(player);
    }

    public void registerTickHandler() {
        Platform.registerServerPlayerPostTickListener(this::updatePlayer);
        VRThrowingExtensions.log.info("[TNTServer] Registered tick handler for fuse timer updates");
    }

    private void updatePlayer(ServerPlayer player) {
        if (!this.hasActiveTimer(player)) {
            return;
        }
        if (!player.isAlive()) {
            this.cancelTNTTimer(player);
            return;
        }
        int remaining = this.getRemainingTicks(player) - 1;
        if (remaining <= 0) {
            this.explodeTNT(player);
            this.cancelTNTTimer(player);
        } else {
            this.tntTimers.put(player, remaining);
        }
    }

    private void explodeTNT(ServerPlayer player) {
        Level level = player.level();
        VRThrowingExtensions.log.debug("[TNTServer] TNT exploded at {}'s position", (Object)player.getName().getString());
        level.explode((Entity)player, player.getX(), player.getY(), player.getZ(), 4.0f, Level.ExplosionInteraction.TNT);
        if (player.getMainHandItem().is(Items.TNT)) {
            player.getMainHandItem().shrink(1);
            if (player.getMainHandItem().isEmpty()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            }
        }
    }
}

