/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.network;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import win.demistorm.ConfigHelper;
import win.demistorm.ModCompat;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.ThrownTNTEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.particles.BleedingParticle;
import win.demistorm.client.particles.BloodParticle;
import win.demistorm.effects.PlaceEffect;
import win.demistorm.effects.ProjectileEffect;
import win.demistorm.network.TNTServer;
import win.demistorm.network.data.BleedingParticleData;
import win.demistorm.network.data.BloodParticleData;
import win.demistorm.network.data.CatchCompleteData;
import win.demistorm.network.data.CatchData;
import win.demistorm.network.data.CatchUpdateData;
import win.demistorm.network.data.ConfigSyncData;
import win.demistorm.network.data.TNTLitData;
import win.demistorm.network.data.ThrowData;
import win.demistorm.network.data.ThrowTNTData;

public final class NetworkHandlers {
    public static void handleThrow(Player player, ThrowData data) {
        if (player == null || !player.isAlive()) {
            return;
        }
        ItemStack heldStack = player.getMainHandItem();
        if (heldStack.isEmpty() || ModCompat.throwingDisabled(heldStack, data.playerCrouched(), data.useBindHeld())) {
            return;
        }
        PlaceEffect.BlockThrowResult blockResult = PlaceEffect.determineBlockThrowLogic(heldStack, data.useBindHeld(), data.playerCrouched());
        if (blockResult.shouldHandle) {
            Vec3 origin = new Vec3(data.posX(), data.posY(), data.posZ());
            Vec3 velocity = new Vec3(data.velX(), data.velY(), data.velZ());
            ThrownProjectileEntity proj = new ThrownProjectileEntity(player.level(), (LivingEntity)player, heldStack, blockResult.throwWholeStack, data.useBindHeld(), data.playerCrouched(), blockResult.shouldPlaceBlock);
            proj.setItem(heldStack.copyWithCount(1));
            proj.setPos(origin);
            proj.setOriginalThrowPos(origin);
            proj.setDeltaMovement(velocity);
            proj.setHandRoll(data.rollDeg());
            VRThrowingExtensions.log.debug("[Server] Spawning block placement proj {} with item {} (placement: {})", new Object[]{proj.getId(), proj.getItem(), blockResult.shouldPlaceBlock});
            player.level().addFreshEntity((Entity)proj);
            if (!player.level().isClientSide()) {
                player.level().playSound(null, player.blockPosition(), SoundEvents.WITCH_THROW, SoundSource.PLAYERS, 0.6f, 1.05f);
            }
            if (blockResult.throwWholeStack) {
                player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            } else if (heldStack.getCount() > 1) {
                heldStack.shrink(1);
            } else {
                player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            }
            return;
        }
        ProjectileEffect.ThrowBehavior behavior = ProjectileEffect.determineThrowBehavior(heldStack, data.useBindHeld(), data.playerCrouched());
        Vec3 origin = new Vec3(data.posX(), data.posY(), data.posZ());
        Vec3 velocity = new Vec3(data.velX(), data.velY(), data.velZ());
        boolean throwWholeStack = behavior == ProjectileEffect.ThrowBehavior.CUSTOM_PROJECTILE_WHOLE_STACK;
        switch (behavior) {
            case VANILLA_PROJECTILE: {
                NetworkHandlers.handleVanillaProjectile(player, heldStack, data);
                break;
            }
            case CUSTOM_PROJECTILE_SINGLE: {
                NetworkHandlers.handleCustomProjectile(player, heldStack, origin, velocity, data.rollDeg(), false, data.useBindHeld(), data.playerCrouched());
                break;
            }
            case CUSTOM_PROJECTILE_WHOLE_STACK: {
                NetworkHandlers.handleCustomProjectile(player, heldStack, origin, velocity, data.rollDeg(), true, data.useBindHeld(), data.playerCrouched());
            }
        }
    }

    private static void handleVanillaProjectile(Player player, ItemStack heldStack, ThrowData data) {
        ItemStack newStack;
        VRThrowingExtensions.log.debug("[Network] Handling vanilla projectile for item: {}", (Object)heldStack);
        ProjectileEffect.ItemProjectileDetector.startTracking((ServerPlayer)player, data.useBindHeld(), data.playerCrouched(), new Vec3(data.posX(), data.posY(), data.posZ()), new Vec3(data.velX(), data.velY(), data.velZ()), data.rollDeg());
        InteractionResult result = heldStack.use(player.level(), player, InteractionHand.MAIN_HAND).getResult();
        if (result != InteractionResult.PASS && (newStack = player.getMainHandItem()).isEmpty()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        if (player.getServer() != null) {
            player.getServer().getTickCount();
            ProjectileEffect.ItemProjectileDetector.interceptAndRedirect((ServerPlayer)player);
        }
    }

    private static void handleCustomProjectile(Player player, ItemStack heldStack, Vec3 origin, Vec3 velocity, float rollDeg, boolean wholeStack, boolean useBindHeld, boolean playerCrouched) {
        VRThrowingExtensions.log.debug("[Network] Handling custom projectile for item: {}", (Object)heldStack);
        ThrownProjectileEntity proj = new ThrownProjectileEntity(player.level(), (LivingEntity)player, heldStack, wholeStack, useBindHeld, playerCrouched);
        proj.setItem(heldStack.copyWithCount(1));
        proj.setPos(origin);
        proj.setOriginalThrowPos(origin);
        proj.setDeltaMovement(velocity);
        proj.setHandRoll(rollDeg);
        VRThrowingExtensions.log.debug("[Server] Spawning thrown proj {} with item {}", (Object)proj.getId(), (Object)proj.getItem());
        player.level().addFreshEntity((Entity)proj);
        float attackDamage = ThrownProjectileEntity.stackBaseDamage(heldStack);
        VRThrowingExtensions.log.debug("[Network] Thrown item attack damage = {}", (Object)Float.valueOf(attackDamage));
        if (!player.level().isClientSide()) {
            if (attackDamage <= 1.0f) {
                player.level().playSound(null, player.blockPosition(), SoundEvents.WITCH_THROW, SoundSource.PLAYERS, 0.6f, 1.05f);
            } else {
                player.level().playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.PLAYERS, 0.6f, 1.33f);
            }
        }
        if (wholeStack) {
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        } else if (heldStack.getCount() > 1) {
            heldStack.shrink(1);
        } else {
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
    }

    public static void handleCatch(Player player, CatchData data) {
        if (player == null || !player.isAlive()) {
            return;
        }
        ServerLevel world = (ServerLevel)player.level();
        Entity entity = world.getEntity(data.entityId());
        if (!(entity instanceof ThrownProjectileEntity)) {
            return;
        }
        ThrownProjectileEntity projectile = (ThrownProjectileEntity)entity;
        if (data.startCatch()) {
            projectile.startCatch();
        } else {
            projectile.cancelCatch();
        }
    }

    public static void handleCatchUpdate(Player player, CatchUpdateData data) {
        if (player == null || !player.isAlive()) {
            return;
        }
        ServerLevel world = (ServerLevel)player.level();
        Entity entity = world.getEntity(data.entityId());
        if (!(entity instanceof ThrownProjectileEntity)) {
            return;
        }
        ThrownProjectileEntity projectile = (ThrownProjectileEntity)entity;
        if (!projectile.isCatching()) {
            return;
        }
        Vec3 newVel = new Vec3(data.velX(), data.velY(), data.velZ());
        projectile.setDeltaMovement(newVel);
        projectile.setHandRoll(data.rollDeg());
    }

    public static void handleCatchComplete(Player player, CatchCompleteData data) {
        if (player == null || !player.isAlive()) {
            return;
        }
        ServerLevel world = (ServerLevel)player.level();
        Entity entity = world.getEntity(data.entityId());
        if (!(entity instanceof ThrownProjectileEntity)) {
            return;
        }
        ThrownProjectileEntity projectile = (ThrownProjectileEntity)entity;
        if (!projectile.isCatching()) {
            return;
        }
        ItemStack mainHand = player.getMainHandItem();
        if (!mainHand.isEmpty()) {
            return;
        }
        ItemStack projectileStack = projectile.getItem();
        int stackSize = projectile.getStackSize();
        if (!player.level().isClientSide()) {
            player.level().playSound(null, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.5f, 2.0f);
        }
        ItemStack giveStack = projectileStack.copy();
        giveStack.setCount(stackSize);
        player.setItemInHand(InteractionHand.MAIN_HAND, giveStack);
        projectile.discard();
    }

    public static void handleBloodParticle(Player player, BloodParticleData data) {
        if (player != null && player.level().isClientSide()) {
            BloodParticle.spawnParticles(data);
        }
        VRThrowingExtensions.log.debug("[Network] Received blood particle packet at ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ()});
    }

    public static void handleBleedingParticle(Player player, BleedingParticleData data) {
        if (player != null && player.level().isClientSide()) {
            BleedingParticle.spawnBleedingParticles(data);
        }
        VRThrowingExtensions.log.debug("[Network] Received bleeding particle packet at ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ()});
    }

    public static void handleConfigSync(Player player, ConfigSyncData data) {
        ConfigHelper.clientReceivedRemote(data.json());
        VRThrowingExtensions.log.debug("[Network] Received config sync packet for player: {}", (Object)player.getName().getString());
    }

    public static void handleTNTLit(Player player, TNTLitData data) {
        if (player == null || !player.isAlive()) {
            return;
        }
        VRThrowingExtensions.log.debug("[Network] {} lit TNT with flint & steel", (Object)player.getName().getString());
        TNTServer.instance().startTNTTimer((ServerPlayer)player);
    }

    public static void handleThrowTNT(Player player, ThrowTNTData data) {
        if (player == null || !player.isAlive()) {
            return;
        }
        VRThrowingExtensions.log.debug("[Network] {} threw lit TNT", (Object)player.getName().getString());
        int remainingTicks = TNTServer.instance().getRemainingTicks((ServerPlayer)player);
        if (remainingTicks <= 0) {
            VRThrowingExtensions.log.warn("[Network] Received throw TNT packet but no active timer for {}", (Object)player.getName().getString());
            return;
        }
        ItemStack heldStack = player.getMainHandItem();
        if (!heldStack.is(Items.TNT)) {
            VRThrowingExtensions.log.warn("[Network] Player {} tried to throw TNT but not holding TNT", (Object)player.getName().getString());
            TNTServer.instance().cancelTNTTimer((ServerPlayer)player);
            return;
        }
        ServerLevel level = (ServerLevel)player.level();
        ThrownTNTEntity tnt = new ThrownTNTEntity(VRThrowingExtensions.THROWN_TNT_TYPE, (Level)level);
        tnt.setPos(data.posX(), data.posY(), data.posZ());
        tnt.setDeltaMovement(data.velX(), data.velY(), data.velZ());
        tnt.setFuse(remainingTicks);
        tnt.setHandRoll(data.rollDeg());
        level.addFreshEntity((Entity)tnt);
        level.playSound(null, player.blockPosition(), SoundEvents.WITCH_THROW, SoundSource.PLAYERS, 0.6f, 1.05f);
        if (heldStack.getCount() > 1) {
            heldStack.shrink(1);
        } else {
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        TNTServer.instance().cancelTNTTimer((ServerPlayer)player);
        VRThrowingExtensions.log.debug("[Network] Spawned lit PrimedTnt with {} tick fuse at ({}, {}, {})", new Object[]{remainingTicks, data.posX(), data.posY(), data.posZ()});
    }
}

