/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import win.demistorm.Platform;

public class NetworkChannel {
    private final List<PacketRegistrationData<?>> packets = new ArrayList();

    public <T> void register(Class<T> clazz, BiConsumer<T, RegistryFriendlyByteBuf> encoder, Function<RegistryFriendlyByteBuf, T> decoder, BiConsumer<T, ServerPlayer> handler) {
        this.packets.add(new PacketRegistrationData<T>(this.packets.size(), clazz, encoder, decoder, handler));
    }

    public <T> void sendToServer(T message) {
        Platform.sendToServer(this.encode(message, this.getClientRegistryAccess()));
    }

    public <T> void sendToPlayer(ServerPlayer player, T message) {
        Platform.sendToPlayer(player, this.encode(message, player.registryAccess()));
    }

    public <T> void handlePacket(ServerPlayer player, RegistryFriendlyByteBuf buffer) {
        Object message;
        int packetId = buffer.readInt();
        if (packetId < 0 || packetId >= this.packets.size()) {
            return;
        }
        PacketRegistrationData<?> data = this.packets.get(packetId);
        try {
            message = data.decoder.apply(buffer);
        }
        catch (Exception e) {
            return;
        }
        data.handler.accept(message, player);
    }

    private <T> RegistryFriendlyByteBuf encode(T message, RegistryAccess access) {
        PacketRegistrationData<T> data = this.getData(message);
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), access);
        buffer.writeInt(data.id());
        data.encoder().accept(message, buffer);
        return buffer;
    }

    private <T> PacketRegistrationData<T> getData(T message) {
        for (PacketRegistrationData<?> data : this.packets) {
            if (data.clazz != message.getClass()) continue;
            return data;
        }
        throw new IllegalArgumentException("Packet type not registered: " + message.getClass().getName());
    }

    private RegistryAccess getClientRegistryAccess() {
        return Platform.getClientRegistryAccess();
    }

    public record PacketRegistrationData<T>(int id, Class<T> clazz, BiConsumer<T, RegistryFriendlyByteBuf> encoder, Function<RegistryFriendlyByteBuf, T> decoder, BiConsumer<T, ServerPlayer> handler) {
    }
}

