/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.network;

import net.minecraft.world.entity.player.Player;
import win.demistorm.network.NetworkChannel;
import win.demistorm.network.NetworkHandlers;
import win.demistorm.network.data.BleedingParticleData;
import win.demistorm.network.data.BloodParticleData;
import win.demistorm.network.data.CatchCompleteData;
import win.demistorm.network.data.CatchData;
import win.demistorm.network.data.CatchUpdateData;
import win.demistorm.network.data.ConfigSyncData;
import win.demistorm.network.data.TNTLitData;
import win.demistorm.network.data.ThrowData;
import win.demistorm.network.data.ThrowTNTData;

public class Network {
    public static final NetworkChannel INSTANCE = new NetworkChannel();

    public static void initialize() {
        Network.registerPackets();
    }

    private static void registerPackets() {
        INSTANCE.register(ThrowData.class, (data, buf) -> {
            buf.writeDouble(data.posX());
            buf.writeDouble(data.posY());
            buf.writeDouble(data.posZ());
            buf.writeDouble(data.velX());
            buf.writeDouble(data.velY());
            buf.writeDouble(data.velZ());
            buf.writeBoolean(data.useBindHeld());
            buf.writeBoolean(data.playerCrouched());
            buf.writeFloat(data.rollDeg());
        }, buf -> new ThrowData(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readBoolean(), buf.readBoolean(), buf.readFloat()), (data, player) -> NetworkHandlers.handleThrow((Player)player, data));
        INSTANCE.register(CatchData.class, (data, buf) -> {
            buf.writeInt(data.entityId());
            buf.writeBoolean(data.startCatch());
        }, buf -> new CatchData(buf.readInt(), buf.readBoolean()), (data, player) -> NetworkHandlers.handleCatch((Player)player, data));
        INSTANCE.register(CatchUpdateData.class, (data, buf) -> {
            buf.writeInt(data.entityId());
            buf.writeDouble(data.velX());
            buf.writeDouble(data.velY());
            buf.writeDouble(data.velZ());
            buf.writeFloat(data.rollDeg());
        }, buf -> new CatchUpdateData(buf.readInt(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat()), (data, player) -> NetworkHandlers.handleCatchUpdate((Player)player, data));
        INSTANCE.register(CatchCompleteData.class, (data, buf) -> buf.writeInt(data.entityId()), buf -> new CatchCompleteData(buf.readInt()), (data, player) -> NetworkHandlers.handleCatchComplete((Player)player, data));
        INSTANCE.register(BloodParticleData.class, (data, buf) -> {
            buf.writeDouble(data.posX());
            buf.writeDouble(data.posY());
            buf.writeDouble(data.posZ());
            buf.writeDouble(data.velX());
            buf.writeDouble(data.velY());
            buf.writeDouble(data.velZ());
        }, buf -> new BloodParticleData(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble()), (data, player) -> NetworkHandlers.handleBloodParticle((Player)player, data));
        INSTANCE.register(BleedingParticleData.class, (data, buf) -> {
            buf.writeDouble(data.posX());
            buf.writeDouble(data.posY());
            buf.writeDouble(data.posZ());
        }, buf -> new BleedingParticleData(buf.readDouble(), buf.readDouble(), buf.readDouble()), (data, player) -> NetworkHandlers.handleBleedingParticle((Player)player, data));
        INSTANCE.register(ConfigSyncData.class, (data, buf) -> {
            buf.writeVarInt(data.json().length());
            buf.writeUtf(data.json());
        }, buf -> {
            int length = buf.readVarInt();
            return new ConfigSyncData(buf.readUtf(length));
        }, (data, player) -> NetworkHandlers.handleConfigSync((Player)player, data));
        INSTANCE.register(TNTLitData.class, (data, buf) -> {}, buf -> new TNTLitData(), (data, player) -> NetworkHandlers.handleTNTLit((Player)player, data));
        INSTANCE.register(ThrowTNTData.class, (data, buf) -> {
            buf.writeDouble(data.posX());
            buf.writeDouble(data.posY());
            buf.writeDouble(data.posZ());
            buf.writeDouble(data.velX());
            buf.writeDouble(data.velY());
            buf.writeDouble(data.velZ());
            buf.writeFloat(data.rollDeg());
        }, buf -> new ThrowTNTData(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat()), (data, player) -> NetworkHandlers.handleThrowTNT((Player)player, data));
    }
}

