/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import win.demistorm.Platform;
import win.demistorm.neoforge.BufferPacket;
import win.demistorm.neoforge.PlatformClientImpl;

public class PlatformImpl {
    public static String getPlatformName() {
        return "NeoForge";
    }

    public static boolean isClientSide() {
        return FMLEnvironment.dist.isClient();
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLEnvironment.production;
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static Path getConfigFolder() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static String getMinecraftVersion() {
        return FMLLoader.versionInfo().mcVersion();
    }

    public static boolean isForgeLike() {
        return true;
    }

    public static void sendToServer(RegistryFriendlyByteBuf buffer) {
        PacketDistributor.sendToServer((CustomPacketPayload)new BufferPacket(buffer), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayer(ServerPlayer player, RegistryFriendlyByteBuf buffer) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new BufferPacket(buffer), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static RegistryAccess getClientRegistryAccess() {
        Minecraft client = Minecraft.getInstance();
        if (client.player != null) {
            return client.player.registryAccess();
        }
        return Objects.requireNonNull(client.level).registryAccess();
    }

    public static void registerServerPostTickListener(Runnable listener) {
        NeoForge.EVENT_BUS.addListener(event -> listener.run());
    }

    public static void registerServerPlayerPostTickListener(Consumer<ServerPlayer> listener) {
        NeoForge.EVENT_BUS.addListener(event -> event.getServer().getPlayerList().getPlayers().forEach(listener));
    }

    public static void registerServerPlayerJoinListener(Consumer<ServerPlayer> listener) {
        NeoForge.EVENT_BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                listener.accept(sp);
            }
        });
    }

    public static void registerServerPlayerLeaveListener(Consumer<ServerPlayer> listener) {
        NeoForge.EVENT_BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                listener.accept(sp);
            }
        });
    }

    public static void registerCommands(Consumer<CommandDispatcher<CommandSourceStack>> registrar) {
        NeoForge.EVENT_BUS.addListener(event -> registrar.accept(event.getDispatcher()));
    }

    public static void registerEntityType(Object entityType) {
    }

    public static String getLoaderName() {
        return "neoforge";
    }

    public static void registerClientInputEventHandlers() {
        PlatformClientImpl.register();
    }

    public static void registerC2SPacketHandler(ResourceLocation packetId, Consumer<Platform.PacketContext> handler) {
    }

    public static void registerS2CPacketHandler(ResourceLocation packetId, Consumer<Platform.PacketContext> handler) {
    }
}

