/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.effects;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import win.demistorm.ConfigHelper;
import win.demistorm.ModCompat;
import win.demistorm.VRThrowingExtensions;

public final class ProjectileEffect {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_FILE = Path.of("config/vr-throwing-extensions/projectile-items.json", new String[0]);
    private static final double SEARCH_RADIUS = 10.0;
    private static volatile Set<ResourceLocation> projectileItems = Sets.newConcurrentHashSet();
    private static volatile Set<Item> projectileItemCache = Sets.newConcurrentHashSet();
    private static final ConcurrentHashMap<UUID, ThrowTracking> activeThrows = new ConcurrentHashMap();

    public static void loadOrCreateConfig() {
        ProjectileEffect.loadProjectileItems();
    }

    public static boolean isProjectileItem(ItemStack stack, boolean playerCrouched, boolean placePressed) {
        if (!ConfigHelper.ACTIVE.throwableProjectiles) {
            return false;
        }
        if (ModCompat.throwingDisabled(stack, playerCrouched, placePressed)) {
            return false;
        }
        Item item = stack.getItem();
        if (projectileItemCache.contains(item)) {
            return true;
        }
        ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey((Object)item);
        boolean isProjectile = projectileItems.contains(itemKey);
        if (isProjectile) {
            projectileItemCache.add(item);
        }
        return isProjectile;
    }

    public static ThrowBehavior determineThrowBehavior(ItemStack stack, boolean useBindHeld, boolean playerCrouched) {
        boolean isProjectile = ProjectileEffect.isProjectileItem(stack, playerCrouched, useBindHeld);
        if (isProjectile) {
            boolean crouchModifierActive;
            switch (ConfigHelper.ACTIVE.crouchBehaviorProjectiles) {
                default: {
                    throw new MatchException(null, null);
                }
                case NORMAL: {
                    boolean bl = playerCrouched;
                    break;
                }
                case INVERTED: {
                    boolean bl = crouchModifierActive = !playerCrouched;
                }
            }
            if (!useBindHeld && !crouchModifierActive) {
                return ThrowBehavior.VANILLA_PROJECTILE;
            }
            if (useBindHeld || crouchModifierActive) {
                return useBindHeld && crouchModifierActive ? ThrowBehavior.CUSTOM_PROJECTILE_WHOLE_STACK : ThrowBehavior.CUSTOM_PROJECTILE_SINGLE;
            }
        } else {
            return useBindHeld ? ThrowBehavior.CUSTOM_PROJECTILE_WHOLE_STACK : ThrowBehavior.CUSTOM_PROJECTILE_SINGLE;
        }
        return ThrowBehavior.CUSTOM_PROJECTILE_SINGLE;
    }

    private static void loadProjectileItems() {
        ProjectileConfig config = ProjectileEffect.readConfig();
        HashSet items = Sets.newHashSet();
        for (String itemId : config.projectile_items) {
            try {
                ResourceLocation key = ResourceLocation.parse((String)itemId);
                if (BuiltInRegistries.ITEM.containsKey(key)) {
                    items.add(key);
                    BuiltInRegistries.ITEM.getOptional(key).ifPresent(projectileItemCache::add);
                    continue;
                }
                VRThrowingExtensions.log.warn("[ProjectileEffect] Unknown item in config: {}", (Object)itemId);
            }
            catch (Exception e) {
                VRThrowingExtensions.log.warn("[ProjectileEffect] Invalid item ID in config: {}", (Object)itemId, (Object)e);
            }
        }
        projectileItems = items;
        VRThrowingExtensions.log.info("[ProjectileEffect] Loaded {} projectile items from config", (Object)items.size());
    }

    private static ProjectileConfig readConfig() {
        try {
            if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
                String json = Files.readString(CONFIG_FILE);
                return (ProjectileConfig)GSON.fromJson(json, ProjectileConfig.class);
            }
        }
        catch (IOException e) {
            VRThrowingExtensions.log.error("[ProjectileEffect] Failed to read config file", (Throwable)e);
        }
        ProjectileConfig config = new ProjectileConfig();
        ProjectileEffect.writeConfig(config);
        return config;
    }

    private static void writeConfig(ProjectileConfig config) {
        try {
            Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)config);
            Files.writeString(CONFIG_FILE, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            VRThrowingExtensions.log.error("[ProjectileEffect] Failed to write config file", (Throwable)e);
        }
    }

    public static List<String> getProjectileItemsList() {
        ArrayList<String> items = new ArrayList<String>();
        for (ResourceLocation key : projectileItems) {
            items.add(key.toString());
        }
        return items;
    }

    public static void setProjectileItemsList(List<String> items) {
        HashSet newItems = Sets.newHashSet();
        Set newCache = Sets.newConcurrentHashSet();
        for (String itemId : items) {
            try {
                ResourceLocation key = ResourceLocation.parse((String)itemId);
                if (BuiltInRegistries.ITEM.containsKey(key)) {
                    newItems.add(key);
                    BuiltInRegistries.ITEM.getOptional(key).ifPresent(newCache::add);
                    continue;
                }
                VRThrowingExtensions.log.warn("[ProjectileEffect] Unknown item ID: {}", (Object)itemId);
            }
            catch (Exception e) {
                VRThrowingExtensions.log.warn("[ProjectileEffect] Invalid item ID: {}", (Object)itemId, (Object)e);
            }
        }
        projectileItems = newItems;
        projectileItemCache = newCache;
        ProjectileConfig config = new ProjectileConfig();
        config.projectile_items = new ArrayList<String>(items);
        ProjectileEffect.writeConfig(config);
        VRThrowingExtensions.log.info("[ProjectileEffect] Updated {} projectile items in config", (Object)newItems.size());
    }

    public static void loadProjectileItemsFromConfig() {
        projectileItemCache.clear();
        ProjectileEffect.loadProjectileItems();
    }

    public static void resetProjectileItems() {
        ProjectileConfig defaultConfig = new ProjectileConfig();
        ProjectileEffect.setProjectileItemsList(defaultConfig.projectile_items);
        VRThrowingExtensions.log.info("[ProjectileEffect] Reset projectile items to defaults ({} items)", (Object)defaultConfig.projectile_items.size());
    }

    private ProjectileEffect() {
    }

    public static enum ThrowBehavior {
        VANILLA_PROJECTILE,
        CUSTOM_PROJECTILE_SINGLE,
        CUSTOM_PROJECTILE_WHOLE_STACK;

    }

    private static class ProjectileConfig {
        public List<String> projectile_items = List.of("minecraft:snowball", "minecraft:egg", "minecraft:blue_egg", "minecraft:brown_egg", "minecraft:ender_pearl", "minecraft:experience_bottle", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:fishing_rod", "minecraft:wind_charge", "minecraft:firework_rocket");

        private ProjectileConfig() {
        }
    }

    public static class ItemProjectileDetector {
        public static void startTracking(ServerPlayer player, boolean useBindHeld, boolean playerCrouched, Vec3 origin, Vec3 velocity, float rollDeg) {
            UUID playerId = player.getUUID();
            ThrowTracking tracking = new ThrowTracking(playerId, useBindHeld, playerCrouched, origin, velocity, rollDeg);
            AABB searchBox = new AABB(player.getX() - 10.0, player.getY() - 10.0, player.getZ() - 10.0, player.getX() + 10.0, player.getY() + 10.0, player.getZ() + 10.0);
            player.level().getEntities((Entity)player, searchBox, entity -> {
                if (entity instanceof Projectile && ItemProjectileDetector.isEntityOwnedByPlayer(entity, player)) {
                    tracking.entitiesBeforeUse.add(entity.getUUID());
                }
                return false;
            });
            activeThrows.put(playerId, tracking);
            VRThrowingExtensions.log.debug("[ProjectileEffect] Started tracking throw for player {}, found {} existing entities", (Object)player.getName().getString(), (Object)tracking.entitiesBeforeUse.size());
        }

        public static void interceptAndRedirect(ServerPlayer player) {
            UUID playerId = player.getUUID();
            ThrowTracking tracking = activeThrows.remove(playerId);
            if (tracking == null) {
                return;
            }
            Level level = player.level();
            AABB searchBox = new AABB(player.getX() - 10.0, player.getY() - 10.0, player.getZ() - 10.0, player.getX() + 10.0, player.getY() + 10.0, player.getZ() + 10.0);
            level.getEntities((Entity)player, searchBox, entity -> {
                if (entity instanceof Projectile) {
                    UUID entityId;
                    Projectile projectile = (Projectile)entity;
                    if (ItemProjectileDetector.isEntityOwnedByPlayer(entity, player) && !tracking.entitiesBeforeUse.contains(entityId = entity.getUUID())) {
                        VRThrowingExtensions.log.debug("[ProjectileEffect] Found new projectile {} for player {}", (Object)entityId, (Object)player.getName().getString());
                        ItemProjectileDetector.redirectProjectile(projectile, tracking);
                    }
                }
                return false;
            });
        }

        private static boolean isEntityOwnedByPlayer(Entity entity, ServerPlayer player) {
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                return projectile.getOwner() == player;
            }
            return false;
        }

        private static void redirectProjectile(Projectile projectile, ThrowTracking tracking) {
            ServerLevel serverLevel = (ServerLevel)projectile.level();
            serverLevel.getChunkSource().removeEntity((Entity)projectile);
            projectile.setPos(tracking.throwOrigin);
            projectile.setDeltaMovement(tracking.throwVelocity);
            serverLevel.getChunkSource().addEntity((Entity)projectile);
            VRThrowingExtensions.log.debug("[ProjectileEffect] Redirected projectile {} to pos {} vel {}", new Object[]{projectile.getId(), tracking.throwOrigin, tracking.throwVelocity});
        }
    }

    public static class ThrowTracking {
        public final UUID playerId;
        public final Set<UUID> entitiesBeforeUse;
        public boolean useBindHeld;
        public boolean playerCrouched;
        public Vec3 throwOrigin;
        public Vec3 throwVelocity;
        public float rollDeg;

        public ThrowTracking(UUID playerId, boolean useBindHeld, boolean playerCrouched, Vec3 origin, Vec3 velocity, float rollDeg) {
            this.playerId = playerId;
            this.entitiesBeforeUse = Sets.newHashSet();
            this.useBindHeld = useBindHeld;
            this.playerCrouched = playerCrouched;
            this.throwOrigin = origin;
            this.throwVelocity = velocity;
            this.rollDeg = rollDeg;
        }
    }
}

