/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.effects;

import java.util.Set;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import win.demistorm.ConfigHelper;
import win.demistorm.VRThrowingExtensions;

public final class PlaceEffect {
    private static final Set<Item> LIGHT_BLOCKS = Set.of(Items.TORCH, Items.SOUL_TORCH, Items.LANTERN, Items.SOUL_LANTERN, Items.REDSTONE_TORCH);

    public static BlockThrowResult determineBlockThrowLogic(ItemStack stack, boolean useBindHeld, boolean playerCrouched) {
        boolean shouldFeatureBeActive;
        if (!ConfigHelper.ACTIVE.placeBlocksOnThrow) {
            return new BlockThrowResult(false, false, false);
        }
        if (PlaceEffect.isPlaceableBlock(stack)) {
            return new BlockThrowResult(false, false, false);
        }
        switch (ConfigHelper.ACTIVE.crouchBehaviorPlaceBlocks) {
            default: {
                throw new MatchException(null, null);
            }
            case NORMAL: {
                boolean bl;
                if (!playerCrouched) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case INVERTED: {
                boolean bl = shouldFeatureBeActive = playerCrouched;
            }
        }
        if (!shouldFeatureBeActive) {
            return new BlockThrowResult(false, false, false);
        }
        if (ConfigHelper.ACTIVE.onlyPlaceLights && !LIGHT_BLOCKS.contains(stack.getItem())) {
            return new BlockThrowResult(false, false, false);
        }
        boolean shouldPlace = !useBindHeld;
        return new BlockThrowResult(true, shouldPlace, false);
    }

    public static boolean placeBlock(Level level, Player player, ItemStack stack, BlockHitResult hitResult, Vec3 impactPos) {
        if (PlaceEffect.isPlaceableBlock(stack)) {
            return false;
        }
        try {
            VRThrowingExtensions.log.debug("[PlaceEffect] Attempting to place {} via vanilla useOn()", (Object)stack.getItem().getDescriptionId());
            UseOnContext context = new UseOnContext(level, player, InteractionHand.MAIN_HAND, stack, hitResult);
            InteractionResult result = stack.getItem().useOn(context);
            boolean success = result.consumesAction();
            if (success) {
                VRThrowingExtensions.log.debug("[PlaceEffect] Successfully placed {} via vanilla useOn()", (Object)stack.getItem().getDescriptionId());
            } else {
                VRThrowingExtensions.log.debug("[PlaceEffect] Placement failed or cancelled for {}", (Object)stack.getItem().getDescriptionId());
            }
            return success;
        }
        catch (Exception e) {
            VRThrowingExtensions.log.error("[PlaceEffect] Failed to place item from stack {}", (Object)stack, (Object)e);
            return false;
        }
    }

    public static boolean isPlaceableBlock(ItemStack stack) {
        Item item = stack.getItem();
        return !(item instanceof BlockItem) && !(item instanceof HangingEntityItem);
    }

    private PlaceEffect() {
    }

    public static class BlockThrowResult {
        public final boolean shouldHandle;
        public final boolean shouldPlaceBlock;
        public final boolean throwWholeStack;

        public BlockThrowResult(boolean shouldHandle, boolean shouldPlaceBlock, boolean throwWholeStack) {
            this.shouldHandle = shouldHandle;
            this.shouldPlaceBlock = shouldPlaceBlock;
            this.throwWholeStack = throwWholeStack;
        }
    }
}

