/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.effects;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.network.Network;
import win.demistorm.network.data.BleedingParticleData;

public final class EmbeddingEffect {
    public static final float targetRollDegX = 70.0f;
    public static final float rollApproachPerTick = 20.0f;
    private static final float forwardSpinSpeedDegPerTick = 15.0f;
    private static final double embedAdjust = 0.3;
    private static final int bleedIntervalTicks = 30;
    private static final float bleedDamage = 1.0f;

    private EmbeddingEffect() {
    }

    public static void startEmbedding(ThrownProjectileEntity proj, EntityHitResult hit, Vec3 clampedHitPos) {
        if (proj.level().isClientSide()) {
            return;
        }
        Entity target = hit.getEntity();
        if (!(target instanceof LivingEntity)) {
            proj.dropAndDiscard();
            return;
        }
        LivingEntity living = (LivingEntity)target;
        Vec3 dir = proj.getDeltaMovement();
        if (dir.lengthSqr() < 1.0E-6) {
            dir = hit.getLocation().subtract(proj.position());
        }
        if (dir.lengthSqr() < 1.0E-6) {
            dir = new Vec3(1.0, 0.0, 0.0);
        }
        dir = dir.normalize();
        Vec3 embedPos = EmbeddingEffect.calculateEmbedPosition(target, clampedHitPos);
        float yaw = (float)(Mth.atan2((double)dir.z, (double)dir.x) * 180.0 / Math.PI);
        float pitch = (float)(Mth.atan2((double)dir.y, (double)Math.sqrt(dir.x * dir.x + dir.z * dir.z)) * 180.0 / Math.PI);
        float tiltDeg = -proj.getHandRoll();
        float initialXRollDeg = (float)proj.tickCount * 15.0f % 360.0f;
        Vec3 worldOffset = embedPos.subtract(target.position());
        proj.beginEmbedding(living, worldOffset, yaw, pitch, tiltDeg, initialXRollDeg);
        BleedManager.register(living, proj.level().getGameTime(), proj);
        proj.level().playSound(null, proj.blockPosition(), SoundEvents.CHAIN_BREAK, SoundSource.PLAYERS, 0.45f, 0.8f);
        double finalEmbedDepth = clampedHitPos.distanceTo(embedPos);
        VRThrowingExtensions.log.debug("[Embed] Projectile {} embedded into {} at {} (+{}), yaw={}, pitch={}, tilt={}, xRollStart={}", new Object[]{proj.getId(), target.getName().getString(), clampedHitPos, String.format("%.2f", finalEmbedDepth), String.format("%.1f", Float.valueOf(yaw)), String.format("%.1f", Float.valueOf(pitch)), String.format("%.1f", Float.valueOf(tiltDeg)), String.format("%.1f", Float.valueOf(initialXRollDeg))});
    }

    private static Vec3 calculateEmbedPosition(Entity target, Vec3 hitPos) {
        AABB boundingBox = target.getBoundingBox();
        Vec3 centerAtHitY = new Vec3(boundingBox.getCenter().x, hitPos.y, boundingBox.getCenter().z);
        Vec3 toCenter = centerAtHitY.subtract(hitPos);
        Vec3 adjustment = toCenter.scale(0.3);
        return hitPos.add(adjustment);
    }

    public static void tickEmbedded(ThrownProjectileEntity proj) {
        LivingEntity living;
        if (!proj.isEmbedded()) {
            return;
        }
        if (proj.level().isClientSide()) {
            return;
        }
        Entity target = proj.getEmbeddedTarget();
        if (!(target instanceof LivingEntity) || !(living = (LivingEntity)target).isAlive() || target.isRemoved()) {
            VRThrowingExtensions.log.debug("[Embed] Host entity lost; dropping projectile {}", (Object)proj.getId());
            proj.clearEmbedding();
            proj.dropAndDiscard();
            return;
        }
        float hostBodyYaw = living.getYHeadRot();
        float hostPitch = living.getXRot();
        Vec3 base = target.position();
        Vec3 offsetWorld = EmbeddingEffect.rotateY(proj.getEmbeddedOffset(), hostBodyYaw);
        Vec3 newPos = base.add(offsetWorld);
        proj.setPos(newPos);
        proj.setDeltaMovement(Vec3.ZERO);
        proj.setNoGravity(true);
        float worldYaw = Mth.wrapDegrees((float)(hostBodyYaw + proj.getEmbeddedLocalYaw()));
        float worldPitch = Mth.wrapDegrees((float)(hostPitch + proj.getEmbeddedLocalPitch()));
        proj.setEmbedYaw(worldYaw);
        proj.setEmbedPitch(worldPitch);
        float current = proj.getEmbedRoll();
        float baseAngle = 70.0f;
        float nearestTarget = baseAngle + 360.0f * (float)Math.round((current - baseAngle) / 360.0f);
        float diff = nearestTarget - current;
        if (Math.abs(diff) > 0.01f) {
            float step = Math.copySign(20.0f, diff);
            float next = Math.abs(diff) <= 20.0f ? nearestTarget : current + step;
            proj.setEmbedRoll(next);
        }
        BleedManager.tryApplyBleed(living, proj.level().getGameTime());
        if (proj.tickCount % 20 == 0) {
            VRThrowingExtensions.log.debug("[Embed] Following host. proj={} bodyYaw={} worldYaw={} pos={}", new Object[]{proj.getId(), String.format("%.1f", Float.valueOf(hostBodyYaw)), String.format("%.1f", Float.valueOf(worldYaw)), proj.position()});
        }
    }

    public static void releaseEmbedding(ThrownProjectileEntity proj) {
        if (!proj.isEmbedded()) {
            return;
        }
        proj.clearEmbedding();
        proj.setNoGravity(true);
        proj.setDeltaMovement(Vec3.ZERO);
        VRThrowingExtensions.log.debug("[Embed] Released projectile {} from embed state for catching", (Object)proj.getId());
    }

    private static Vec3 rotateY(Vec3 v, float degrees) {
        double rad = Math.toRadians(degrees);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double x = v.x * cos - v.z * sin;
        double z = v.x * sin + v.z * cos;
        return new Vec3(x, v.y, z);
    }

    public static final class BleedManager {
        private static final Map<LivingEntity, BleedState> STATES = new WeakHashMap<LivingEntity, BleedState>();

        static void register(LivingEntity host, long worldTime, ThrownProjectileEntity proj) {
            BleedState st = STATES.get(host);
            if (st == null) {
                st = new BleedState(worldTime);
                STATES.put(host, st);
                VRThrowingExtensions.log.debug("[Bleed] Anchor set for {} at worldTick={}", (Object)host.getName().getString(), (Object)worldTime);
            }
            st.projs.add(proj);
            VRThrowingExtensions.log.debug("[Bleed] Added embed for {}. count={}", (Object)host.getName().getString(), (Object)st.projs.size());
        }

        public static void unregister(LivingEntity host, ThrownProjectileEntity proj) {
            BleedState st = STATES.get(host);
            if (st == null) {
                return;
            }
            st.projs.remove((Object)proj);
            if (st.projs.isEmpty()) {
                STATES.remove(host);
                VRThrowingExtensions.log.debug("[Bleed] Cleared bleed state for {} (no more embeds)", (Object)host.getName().getString());
            } else {
                VRThrowingExtensions.log.debug("[Bleed] Removed embed for {}. Remaining count={}", (Object)host.getName().getString(), (Object)st.projs.size());
            }
        }

        static void tryApplyBleed(LivingEntity host, long worldTime) {
            BleedState st = STATES.get(host);
            if (st == null) {
                return;
            }
            if (!host.isAlive()) {
                STATES.remove(host);
                VRThrowingExtensions.log.debug("[Bleed] Host {} died. Removing bleed state.", (Object)host.getName().getString());
                return;
            }
            long delta = worldTime - st.anchorTick;
            if (delta < 30L) {
                return;
            }
            if (delta % 30L != 0L) {
                return;
            }
            if (st.lastAppliedTick == worldTime) {
                return;
            }
            st.lastAppliedTick = worldTime;
            int activeCount = 0;
            for (ThrownProjectileEntity p : st.projs) {
                if (p == null || p.isRemoved() || !p.isEmbedded()) continue;
                ++activeCount;
            }
            if (activeCount <= 0) {
                STATES.remove(host);
                return;
            }
            float total = 1.0f * (float)activeCount;
            ServerLevel sw = (ServerLevel)host.level();
            host.hurt(sw.damageSources().generic(), total);
            for (ThrownProjectileEntity p : st.projs) {
                if (p == null || p.isRemoved() || !p.isEmbedded()) continue;
                Vec3 pos = p.position();
                for (ServerPlayer player : sw.getServer().getPlayerList().getPlayers()) {
                    if (player.level() != sw || !(player.distanceToSqr(pos) < 4096.0)) continue;
                    Network.INSTANCE.sendToPlayer(player, new BleedingParticleData(pos.x, pos.y, pos.z));
                }
            }
            VRThrowingExtensions.log.debug("[Bleed] Applied {} bleed to {} at tick {} (embeds={}, anchor={})", new Object[]{Float.valueOf(total), host.getName().getString(), worldTime, activeCount, st.anchorTick});
        }

        private static final class BleedState {
            final long anchorTick;
            long lastAppliedTick = Long.MIN_VALUE;
            final Set<ThrownProjectileEntity> projs = Collections.newSetFromMap(new IdentityHashMap());

            BleedState(long anchorTick) {
                this.anchorTick = anchorTick;
            }
        }
    }
}

