/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class ItemInfoCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"itemInfo").executes(ItemInfoCommand::getItemInfo));
    }

    private static int getItemInfo(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack stack = player.getMainHandItem();
            if (stack.isEmpty()) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7cNo item in main hand!"));
                return 0;
            }
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76========== ITEM INFO =========="));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eDisplay Name: \u00a7f" + stack.getHoverName().getString())));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eItem ID: \u00a7f" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())))));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eItem Class: \u00a7f" + stack.getItem().getClass().getName())));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eItem Class (simple): \u00a7f" + stack.getItem().getClass().getSimpleName())));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eCount: \u00a7f" + stack.getCount())));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eMax Stack Size: \u00a7f" + stack.getMaxStackSize())));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eDamage: \u00a7f" + stack.getDamageValue())));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eMax Damage: \u00a7f" + stack.getMaxDamage())));
            CustomData tag = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (tag != null && !tag.isEmpty()) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7aCustom NBT Data:"));
                try {
                    String nbtString = tag.copyTag().toString();
                    player.sendSystemMessage((Component)Component.literal((String)nbtString));
                }
                catch (Exception e) {
                    player.sendSystemMessage((Component)Component.literal((String)("  \u00a7cError reading NBT: " + e.getMessage())));
                }
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a77Custom NBT Data: \u00a7o(None)"));
            }
            DataComponentMap components = stack.getComponents();
            if (components != null && !components.isEmpty()) {
                ItemAttributeModifiers attributes;
                ItemEnchantments enchantments;
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7aComponents: \u00a7f" + components.size() + " entries")));
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7eKey Components:"));
                if (stack.has(DataComponents.DAMAGE)) {
                    player.sendSystemMessage((Component)Component.literal((String)("  \u00a7f- DAMAGE: " + String.valueOf(stack.get(DataComponents.DAMAGE)))));
                }
                if ((enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)) != null && !enchantments.isEmpty()) {
                    player.sendSystemMessage((Component)Component.literal((String)("  \u00a7f- ENCHANTMENTS: " + String.valueOf(enchantments))));
                }
                if (stack.has(DataComponents.CUSTOM_NAME)) {
                    player.sendSystemMessage((Component)Component.literal((String)("  \u00a7f- CUSTOM_NAME: " + String.valueOf(stack.get(DataComponents.CUSTOM_NAME)))));
                }
                if ((attributes = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS)) != null && !attributes.modifiers().isEmpty()) {
                    player.sendSystemMessage((Component)Component.literal((String)("  \u00a7f- ATTRIBUTE_MODIFIERS: " + attributes.modifiers().size() + " modifiers")));
                }
                if (stack.has(DataComponents.CUSTOM_MODEL_DATA)) {
                    player.sendSystemMessage((Component)Component.literal((String)("  \u00a7f- CUSTOM_MODEL_DATA: " + String.valueOf(stack.get(DataComponents.CUSTOM_MODEL_DATA)))));
                }
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7eAll component types:"));
                for (TypedDataComponent componentType : components) {
                    player.sendSystemMessage((Component)Component.literal((String)("  \u00a77- " + componentType.type().toString())));
                }
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a77Components: \u00a7o(None)"));
            }
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eIs Damageable: \u00a7f" + stack.isDamageableItem())));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eIs Enchantable: \u00a7f" + stack.isEnchantable())));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eRarity: \u00a7f" + String.valueOf(stack.getRarity()))));
            FoodProperties food = (FoodProperties)stack.get(DataComponents.FOOD);
            if (food != null) {
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7aIs Food: \u00a7fYes (Nutrition: " + food.nutrition() + ")")));
            }
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76==============================="));
            return 1;
        }
        return 0;
    }
}

