/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client.particles;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.config.ClientOnlyConfig;
import win.demistorm.network.data.BloodParticleData;

public final class BloodParticle {
    private static final int particleCount = 32;
    private static final int particleVariation = 6;
    private static final double coneAngleBase = 12.0;
    private static final double coneAngleVariation = 10.0;
    private static final double mistSpread = 0.2;
    private static final double mistVelMultiplier = 0.3;
    private static final double dropletRatio = 0.6;
    private static final double dropletSideJitter = 0.12;
    private static final double dropletSpeedScale = 1.0;
    private static final float scaleBase = 1.0f;
    private static final float scaleVariation = 0.4f;

    public static void spawnParticles(BloodParticleData data) {
        if (!ClientOnlyConfig.ACTIVE.bloodEffect) {
            VRThrowingExtensions.log.debug("[Blood Effect] Blood particles disabled by config, skipping spawn at ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ()});
            return;
        }
        VRThrowingExtensions.log.debug("[Blood Effect] Spawning blood particles at ({}, {}, {}) with velocity ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ(), data.velX(), data.velY(), data.velZ()});
        Vec3 pos = new Vec3(data.posX(), data.posY(), data.posZ());
        Vec3 velocity = new Vec3(data.velX(), data.velY(), data.velZ());
        BloodParticle.spawnBloodParticles(pos, velocity);
    }

    private static void spawnBloodParticles(Vec3 pos, Vec3 velocity) {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        double speed = velocity.length();
        Vec3 forward = BloodParticle.normalizeSafely(velocity, new Vec3(0.0, 0.0, -1.0));
        Basis basis = BloodParticle.makePerpendicularBasis(forward);
        double coneDeg = 12.0 + rng.nextDouble() * 10.0;
        int count = 32 + rng.nextInt(-6, 7);
        for (int i = 0; i < count; ++i) {
            Vec3 vel;
            boolean spawnDroplet;
            double ox = rng.nextDouble(-0.15, 0.15);
            double oy = rng.nextDouble(-0.15, 0.15);
            double oz = rng.nextDouble(-0.15, 0.15);
            Vec3 sprayForward = BloodParticle.randomDirectionCone(basis, coneDeg, rng);
            float r = 0.6f + (float)rng.nextDouble(0.0, 0.4);
            float g = (float)rng.nextDouble(0.0, 0.1);
            float b = (float)rng.nextDouble(0.0, 0.05);
            float scale = 1.0f + (float)rng.nextDouble(-0.2f, 0.2f);
            boolean bl = spawnDroplet = rng.nextDouble() < 0.6;
            if (spawnDroplet) {
                double jitterU = rng.nextDouble(-0.12, 0.12);
                double jitterV = rng.nextDouble(-0.12, 0.12);
                Vec3 jitter = basis.u.scale(jitterU).add(basis.v.scale(jitterV));
                vel = sprayForward.scale(speed * 1.0).add(jitter);
                client.level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.RED_DYE)), pos.x + ox, pos.y + oy, pos.z + oz, vel.x, vel.y, vel.z);
                continue;
            }
            double mistU = rng.nextDouble(-0.2, 0.2);
            double mistV = rng.nextDouble(-0.2, 0.2);
            Vec3 sideways = basis.u.scale(mistU).add(basis.v.scale(mistV));
            vel = sprayForward.scale(0.3 * speed).add(sideways);
            Vector3f color = new Vector3f(r, g, b);
            DustParticleOptions blood = new DustParticleOptions(color, scale);
            client.level.addParticle((ParticleOptions)blood, pos.x + ox, pos.y + oy, pos.z + oz, vel.x, vel.y, vel.z);
        }
    }

    private static Vec3 normalizeSafely(Vec3 v, Vec3 fallback) {
        double len2 = v.lengthSqr();
        if (len2 < 1.0E-8) {
            return fallback;
        }
        return v.scale(1.0 / Math.sqrt(len2));
    }

    private static Basis makePerpendicularBasis(Vec3 forward) {
        Vec3 f = BloodParticle.normalizeSafely(forward, new Vec3(0.0, 0.0, -1.0));
        Vec3 up = Math.abs(f.y) < 0.999 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
        Vec3 u = f.cross(up);
        u = BloodParticle.normalizeSafely(u, new Vec3(1.0, 0.0, 0.0));
        Vec3 v = f.cross(u);
        return new Basis(f, u, v);
    }

    private static Vec3 randomDirectionCone(Basis basis, double maxAngleDegrees, ThreadLocalRandom rng) {
        double maxRad = Math.toRadians(maxAngleDegrees);
        double cosAlpha = Mth.lerp((double)rng.nextDouble(), (double)Math.cos(maxRad), (double)1.0);
        double sinAlpha = Math.sqrt(Math.max(0.0, 1.0 - cosAlpha * cosAlpha));
        double theta = rng.nextDouble(0.0, Math.PI * 2);
        double ct = Math.cos(theta);
        double st = Math.sin(theta);
        Vec3 lateral = basis.u.scale(ct).add(basis.v.scale(st));
        return basis.f.scale(cosAlpha).add(lateral.scale(sinAlpha)).normalize();
    }

    private BloodParticle() {
    }

    private record Basis(Vec3 f, Vec3 u, Vec3 v) {
    }
}

