/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client.particles;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.config.ClientOnlyConfig;
import win.demistorm.network.data.BleedingParticleData;

public final class BleedingParticle {
    private static final int baseCount = 10;
    private static final int countVariation = 4;
    private static final double lateralJitter = 0.02;
    private static final double velDownMin = -0.08;
    private static final double velDownMax = -0.02;
    private static final double velSideMin = -0.015;
    private static final double velSideMax = 0.015;
    private static final float dustScaleBase = 0.45f;
    private static final float dustScaleVar = 0.2f;
    private static final double redDyeChance = 0.35;

    public static void spawnBleedingParticles(BleedingParticleData data) {
        if (!ClientOnlyConfig.ACTIVE.bloodEffect) {
            VRThrowingExtensions.log.debug("[Bleeding Effect] Bleeding particles disabled by config, skipping spawn at ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ()});
            return;
        }
        VRThrowingExtensions.log.debug("[Bleeding Effect] Spawning bleeding particles at ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ()});
        Vec3 pos = new Vec3(data.posX(), data.posY(), data.posZ());
        BleedingParticle.spawnBleedTrickle(pos);
    }

    private static void spawnBleedTrickle(Vec3 pos) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        int count = 10 + rng.nextInt(-4, 5);
        for (int i = 0; i < count; ++i) {
            double ox = rng.nextDouble(-0.02, 0.02);
            double oy = rng.nextDouble(-0.02, 0.02);
            double oz = rng.nextDouble(-0.02, 0.02);
            double vx = rng.nextDouble(-0.015, 0.015);
            double vy = rng.nextDouble(-0.08, -0.02);
            double vz = rng.nextDouble(-0.015, 0.015);
            if (rng.nextDouble() < 0.35) {
                mc.level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.RED_DYE)), pos.x + ox, pos.y + oy, pos.z + oz, vx, vy, vz);
                continue;
            }
            Vector3f color = new Vector3f(0.6f + rng.nextFloat() * 0.35f, rng.nextFloat() * 0.08f, rng.nextFloat() * 0.06f);
            float scale = 0.45f + (rng.nextFloat() - 0.5f) * 0.2f;
            DustParticleOptions bloodDust = new DustParticleOptions(color, scale);
            mc.level.addParticle((ParticleOptions)bloodDust, pos.x + ox, pos.y + oy, pos.z + oz, vx, vy, vz);
        }
    }

    private BleedingParticle() {
    }
}

