/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client.config;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import win.demistorm.ConfigHelper;
import win.demistorm.effects.ProjectileEffect;

public class ThrowableItemsScreen
extends Screen {
    private final Screen parent;
    private final Minecraft client = Minecraft.getInstance();
    private EditBox itemIdInput;
    private ItemListWidget itemList;
    private Button toggleButton;
    private int listTopY;
    private List<String> projectileItems;
    private boolean throwableProjectilesEnabled;
    private ConfigHelper.CrouchBehavior crouchBehaviorValue;

    protected ThrowableItemsScreen(Screen parent) {
        super((Component)Component.literal((String)"Configure Throwable Projectiles"));
        this.crouchBehaviorValue = ConfigHelper.CLIENT.crouchBehaviorProjectiles;
        this.parent = parent;
        this.projectileItems = ProjectileEffect.getProjectileItemsList();
        this.throwableProjectilesEnabled = ConfigHelper.CLIENT.throwableProjectiles;
    }

    protected void init() {
        int topY = 40;
        int listTopY = topY + 80;
        int bottomMargin = 70;
        this.itemIdInput = new EditBox(this.font, 20, topY, 180, 18, (Component)Component.literal((String)"Item ID"));
        this.itemIdInput.setHint((Component)Component.literal((String)"minecraft:snowball"));
        this.itemIdInput.setMaxLength(100);
        this.addRenderableWidget((GuiEventListener)this.itemIdInput);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Add"), btn -> this.addItemId()).bounds(205, topY, 40, 18).build());
        this.toggleButton = Button.builder((Component)Component.literal((String)("Throwable Projectiles: " + (this.throwableProjectilesEnabled ? "ON" : "OFF"))), btn -> {
            this.throwableProjectilesEnabled = !this.throwableProjectilesEnabled;
            btn.setMessage((Component)Component.literal((String)("Throwable Projectiles: " + (this.throwableProjectilesEnabled ? "ON" : "OFF"))));
            ConfigHelper.setThrowableProjectilesEnabled(this.throwableProjectilesEnabled);
        }).bounds(this.width - 180, topY, 160, 18).tooltip(Tooltip.create((Component)Component.literal((String)"Enable VR control over vanilla projectile items"))).build();
        this.addRenderableWidget((GuiEventListener)this.toggleButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Crouch Behavior: " + this.crouchBehaviorValue.name())), btn -> {
            this.crouchBehaviorValue = this.crouchBehaviorValue == ConfigHelper.CrouchBehavior.NORMAL ? ConfigHelper.CrouchBehavior.INVERTED : ConfigHelper.CrouchBehavior.NORMAL;
            btn.setMessage((Component)Component.literal((String)("Crouch Behavior: " + this.crouchBehaviorValue.name())));
            ConfigHelper.setCrouchBehaviorProjectiles(this.crouchBehaviorValue);
        }).bounds(this.width - 180, topY + 23, 160, 18).tooltip(Tooltip.create((Component)Component.literal((String)"NORMAL: Crouch throws projectile without effect\nINVERTED: Crouch activates effect"))).build());
        int listBottom = this.height - bottomMargin;
        this.itemList = new ItemListWidget(this.client, this.width, this.height, listTopY, listBottom);
        this.itemList.updateEntries();
        this.addWidget((GuiEventListener)this.itemList);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Done"), btn -> {
            ConfigHelper.CLIENT.crouchBehaviorProjectiles = this.crouchBehaviorValue;
            ConfigHelper.write(ConfigHelper.CLIENT);
            ProjectileEffect.setProjectileItemsList(this.projectileItems);
            this.client.setScreen(this.parent);
        }).bounds(this.width / 2 - 100, this.height - 30, 200, 20).build());
    }

    private void addItemId() {
        String text = this.itemIdInput.getValue().trim();
        if (!text.isEmpty() && !this.projectileItems.contains(text)) {
            this.projectileItems.add(text);
            this.itemIdInput.setValue("");
            this.itemList.updateEntries();
            ProjectileEffect.setProjectileItemsList(this.projectileItems);
        }
    }

    private void removeItemId(String itemId) {
        this.projectileItems.remove(itemId);
        this.itemList.updateEntries();
        ProjectileEffect.setProjectileItemsList(this.projectileItems);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        if (this.itemList != null) {
            this.itemList.render(context, mouseX, mouseY, delta);
        }
        context.drawCenteredString(this.font, this.title, this.width / 2, 10, 0xFFFFFF);
        context.drawString(this.font, "Add Item ID:", 20, 28, 0xFFFFFF);
        context.drawString(this.font, "Custom Projectile Items:", 20, this.listTopY + 105, 0xFFFFFF);
        context.drawString(this.font, "(" + this.projectileItems.size() + " items)", 180, this.listTopY + 105, 0xAAAAAA);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.itemIdInput.isFocused() && (keyCode == 257 || keyCode == 335)) {
            this.addItemId();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private class ItemListWidget
    extends ObjectSelectionList<ItemEntry> {
        public ItemListWidget(Minecraft client, int width, int height, int y, int bottom) {
            super(client, width, bottom - y, y, 20);
        }

        public void updateEntries() {
            this.clearEntries();
            for (int i = 0; i < ThrowableItemsScreen.this.projectileItems.size(); i += 2) {
                String leftItem = ThrowableItemsScreen.this.projectileItems.get(i);
                String rightItem = i + 1 < ThrowableItemsScreen.this.projectileItems.size() ? ThrowableItemsScreen.this.projectileItems.get(i + 1) : null;
                this.addEntry((AbstractSelectionList.Entry)new ItemEntry(leftItem, rightItem));
            }
        }

        public int getRowWidth() {
            return this.width - 60;
        }

        public class ItemEntry
        extends ObjectSelectionList.Entry<ItemEntry> {
            private final String leftItem;
            private final String rightItem;
            private final Button leftRemoveButton;
            private final Button rightRemoveButton;

            public ItemEntry(String leftItem, String rightItem) {
                this.leftItem = leftItem;
                this.rightItem = rightItem;
                this.leftRemoveButton = Button.builder((Component)Component.literal((String)"\u00d7"), btn -> ThrowableItemsScreen.this.removeItemId(leftItem)).bounds(0, 0, 16, 16).tooltip(Tooltip.create((Component)Component.literal((String)("Remove " + leftItem)))).build();
                this.rightRemoveButton = rightItem != null ? Button.builder((Component)Component.literal((String)"\u00d7"), btn -> ThrowableItemsScreen.this.removeItemId(rightItem)).bounds(0, 0, 16, 16).tooltip(Tooltip.create((Component)Component.literal((String)("Remove " + rightItem)))).build() : null;
            }

            public void render(GuiGraphics context, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
                int columnWidth = width / 2;
                Object leftDisplay = this.leftItem;
                int leftTextWidth = ThrowableItemsScreen.this.font.width((String)leftDisplay);
                if (leftTextWidth > columnWidth - 25) {
                    leftDisplay = ThrowableItemsScreen.this.font.plainSubstrByWidth(this.leftItem, columnWidth - 30) + "...";
                }
                context.drawString(ThrowableItemsScreen.this.font, (String)leftDisplay, x + 5, y + 4, 0xFFFFFF);
                this.leftRemoveButton.setPosition(x + columnWidth - 20, y + 1);
                this.leftRemoveButton.render(context, mouseX, mouseY, delta);
                if (this.rightItem != null) {
                    Object rightDisplay = this.rightItem;
                    int rightTextWidth = ThrowableItemsScreen.this.font.width((String)rightDisplay);
                    if (rightTextWidth > columnWidth - 25) {
                        rightDisplay = ThrowableItemsScreen.this.font.plainSubstrByWidth(this.rightItem, columnWidth - 30) + "...";
                    }
                    context.drawString(ThrowableItemsScreen.this.font, (String)rightDisplay, x + columnWidth + 5, y + 4, 0xFFFFFF);
                    this.rightRemoveButton.setPosition(x + width - 20, y + 1);
                    this.rightRemoveButton.render(context, mouseX, mouseY, delta);
                }
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.leftRemoveButton.mouseClicked(mouseX, mouseY, button)) {
                    return true;
                }
                return this.rightRemoveButton != null && this.rightRemoveButton.mouseClicked(mouseX, mouseY, button);
            }

            public Component getNarration() {
                return Component.literal((String)(this.leftItem + (String)(this.rightItem != null ? " and " + this.rightItem : "")));
            }
        }
    }
}

