/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client.config;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import win.demistorm.ConfigHelper;
import win.demistorm.client.config.ClientOnlyConfig;
import win.demistorm.client.config.CompatScreen;

public final class ExtrasScreen {
    private ExtrasScreen() {
    }

    public static class ExtrasToggleScreen
    extends Screen {
        private final Screen parent;
        private final Minecraft client = Minecraft.getInstance();
        private boolean placeBlocksOnThrowValue;
        private boolean onlyPlaceLightsValue;
        private boolean bloodEffectValue;
        private boolean throwableTNTValue;
        private ConfigHelper.CrouchBehavior crouchBehaviorPlaceBlocksValue;
        private Button onlyLightsButton;
        private Button crouchBehaviorButton;

        protected ExtrasToggleScreen(Screen parent) {
            super((Component)Component.literal((String)"VR Throwing Extensions - Extras"));
            this.placeBlocksOnThrowValue = ConfigHelper.CLIENT.placeBlocksOnThrow;
            this.onlyPlaceLightsValue = ConfigHelper.CLIENT.onlyPlaceLights;
            this.bloodEffectValue = ClientOnlyConfig.ACTIVE.bloodEffect;
            this.throwableTNTValue = ConfigHelper.CLIENT.throwableTNT;
            this.crouchBehaviorPlaceBlocksValue = ConfigHelper.CLIENT.crouchBehaviorPlaceBlocks;
            this.parent = parent;
        }

        public static ExtrasToggleScreen create(Screen parent) {
            return new ExtrasToggleScreen(parent);
        }

        protected void init() {
            Button placeBlocksButton = Button.builder((Component)Component.literal((String)("Place Blocks on Throw: " + (this.placeBlocksOnThrowValue ? "ON" : "OFF"))), btn -> {
                this.placeBlocksOnThrowValue = !this.placeBlocksOnThrowValue;
                btn.setMessage((Component)Component.literal((String)("Place Blocks on Throw: " + (this.placeBlocksOnThrowValue ? "ON" : "OFF"))));
                this.updateOnlyLightsButton();
                ConfigHelper.setPlaceBlocksOnThrowEnabled(this.placeBlocksOnThrowValue);
            }).bounds(this.width / 2 - 165, this.height / 6 - 10, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Place blocks when thrown into other blocks"))).build();
            this.addRenderableWidget((GuiEventListener)placeBlocksButton);
            this.onlyLightsButton = Button.builder((Component)Component.literal((String)("Only Place Lights: " + (this.onlyPlaceLightsValue ? "ON" : "OFF"))), btn -> {
                this.onlyPlaceLightsValue = !this.onlyPlaceLightsValue;
                btn.setMessage((Component)Component.literal((String)("Only Place Lights: " + (this.onlyPlaceLightsValue ? "ON" : "OFF"))));
                ConfigHelper.setOnlyPlaceLightsEnabled(this.onlyPlaceLightsValue);
            }).bounds(this.width / 2 + 5, this.height / 6 - 10, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Only place torches/lanterns when thrown"))).build();
            this.onlyLightsButton.active = this.placeBlocksOnThrowValue;
            this.addRenderableWidget((GuiEventListener)this.onlyLightsButton);
            this.crouchBehaviorButton = Button.builder((Component)Component.literal((String)("Crouch Behavior: " + this.crouchBehaviorPlaceBlocksValue.name())), btn -> {
                this.crouchBehaviorPlaceBlocksValue = this.crouchBehaviorPlaceBlocksValue == ConfigHelper.CrouchBehavior.NORMAL ? ConfigHelper.CrouchBehavior.INVERTED : ConfigHelper.CrouchBehavior.NORMAL;
                btn.setMessage((Component)Component.literal((String)("Crouch Behavior: " + this.crouchBehaviorPlaceBlocksValue.name())));
                ConfigHelper.setCrouchBehaviorPlaceBlocks(this.crouchBehaviorPlaceBlocksValue);
            }).bounds(this.width / 2 - 165, this.height / 6 + 11, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"NORMAL: Crouch throws projectile without effect\nINVERTED: Crouch activates effect"))).build();
            this.crouchBehaviorButton.active = this.placeBlocksOnThrowValue;
            this.addRenderableWidget((GuiEventListener)this.crouchBehaviorButton);
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Blood Particles: " + (this.bloodEffectValue ? "ON" : "OFF"))), btn -> {
                this.bloodEffectValue = !this.bloodEffectValue;
                btn.setMessage((Component)Component.literal((String)("Blood Particles: " + (this.bloodEffectValue ? "ON" : "OFF"))));
            }).bounds(this.width / 2 - 80, this.height / 6 + 32, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Show blood particles when weapons hit"))).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Throwable TNT: " + (this.throwableTNTValue ? "ON" : "OFF"))), btn -> {
                this.throwableTNTValue = !this.throwableTNTValue;
                btn.setMessage((Component)Component.literal((String)("Throwable TNT: " + (this.throwableTNTValue ? "ON" : "OFF"))));
                ConfigHelper.setThrowableTNTEnabled(this.throwableTNTValue);
            }).bounds(this.width / 2 - 80, this.height / 6 + 53, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Enable/disable immersive TNT throwing"))).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Compat Toggles..."), btn -> this.client.setScreen((Screen)new CompatScreen.CompatToggleScreen(this))).bounds(this.width / 2 - 80, this.height / 6 + 74, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Mod Compatibility Settings"))).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Done"), btn -> {
                ConfigHelper.CLIENT.placeBlocksOnThrow = this.placeBlocksOnThrowValue;
                ConfigHelper.CLIENT.onlyPlaceLights = this.onlyPlaceLightsValue;
                ConfigHelper.CLIENT.crouchBehaviorPlaceBlocks = this.crouchBehaviorPlaceBlocksValue;
                ConfigHelper.write(ConfigHelper.CLIENT);
                ClientOnlyConfig.ACTIVE.bloodEffect = this.bloodEffectValue;
                ClientOnlyConfig.write(ClientOnlyConfig.ACTIVE);
                if (this.client.hasSingleplayerServer()) {
                    ConfigHelper.ACTIVE.placeBlocksOnThrow = ConfigHelper.CLIENT.placeBlocksOnThrow;
                    ConfigHelper.ACTIVE.onlyPlaceLights = ConfigHelper.CLIENT.onlyPlaceLights;
                    ConfigHelper.ACTIVE.crouchBehaviorPlaceBlocks = ConfigHelper.CLIENT.crouchBehaviorPlaceBlocks;
                }
                this.client.setScreen(this.parent);
            }).bounds(this.width / 2 - 100, this.height - 30, 200, 20).build());
        }

        private void updateOnlyLightsButton() {
            if (this.onlyLightsButton != null) {
                this.onlyLightsButton.active = this.placeBlocksOnThrowValue;
                if (!this.placeBlocksOnThrowValue) {
                    this.onlyPlaceLightsValue = false;
                    this.onlyLightsButton.setMessage((Component)Component.literal((String)"Only Place Lights: OFF"));
                    ConfigHelper.setOnlyPlaceLightsEnabled(false);
                }
            }
            if (this.crouchBehaviorButton != null) {
                this.crouchBehaviorButton.active = this.placeBlocksOnThrowValue;
            }
        }

        public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
            this.renderBackground(context, mouseX, mouseY, delta);
            super.render(context, mouseX, mouseY, delta);
            context.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        }
    }
}

