/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client.config;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import win.demistorm.ConfigHelper;
import win.demistorm.WeaponEffectType;
import win.demistorm.client.config.ClientOnlyConfig;
import win.demistorm.client.config.ExtrasScreen;
import win.demistorm.client.config.ThrowableItemsScreen;
import win.demistorm.effects.ProjectileEffect;

public final class ConfigScreen {
    private ConfigScreen() {
    }

    public static class SimpleToggleScreen
    extends Screen {
        private final Screen parent;
        private final Minecraft client = Minecraft.getInstance();
        private WeaponEffectType weaponEffectValue;
        private boolean aimAssistValue;
        private Button weaponEffectButton;
        private Button aimAssistButton;

        protected SimpleToggleScreen(Screen parent) {
            super((Component)Component.literal((String)"VR Throwing Extensions Configuration"));
            this.weaponEffectValue = ConfigHelper.CLIENT.weaponEffect;
            this.aimAssistValue = ConfigHelper.CLIENT.aimAssist;
            this.parent = parent;
        }

        public static SimpleToggleScreen create(Screen parent) {
            return new SimpleToggleScreen(parent);
        }

        protected void init() {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Reset"), btn -> {
                this.weaponEffectValue = WeaponEffectType.BOOMERANG;
                this.aimAssistValue = true;
                ConfigHelper.CLIENT.weaponEffect = WeaponEffectType.BOOMERANG;
                ConfigHelper.CLIENT.aimAssist = true;
                ConfigHelper.CLIENT.throwableProjectiles = true;
                ConfigHelper.CLIENT.placeBlocksOnThrow = false;
                ConfigHelper.CLIENT.onlyPlaceLights = false;
                ConfigHelper.CLIENT.throwableTNT = true;
                ConfigHelper.CLIENT.immersiveMCThrowables = true;
                ConfigHelper.CLIENT.throwConflictingItems = true;
                ConfigHelper.CLIENT.crouchBehaviorProjectiles = ConfigHelper.CrouchBehavior.NORMAL;
                ConfigHelper.CLIENT.crouchBehaviorPlaceBlocks = ConfigHelper.CrouchBehavior.INVERTED;
                ConfigHelper.write(ConfigHelper.CLIENT);
                ClientOnlyConfig.ACTIVE.bloodEffect = true;
                ClientOnlyConfig.write(ClientOnlyConfig.ACTIVE);
                ProjectileEffect.resetProjectileItems();
                if (this.weaponEffectButton != null) {
                    this.weaponEffectButton.setMessage((Component)Component.literal((String)("Weapon Effect: " + this.weaponEffectValue.name())));
                }
                if (this.aimAssistButton != null) {
                    this.aimAssistButton.setMessage((Component)Component.literal((String)("Aim Assist: " + (this.aimAssistValue ? "ON" : "OFF"))));
                }
            }).bounds(this.width - 50, 5, 45, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Reset all settings to default"))).build());
            this.weaponEffectButton = Button.builder((Component)Component.literal((String)("Weapon Effect: " + this.weaponEffectValue.name())), btn -> {
                this.weaponEffectValue = switch (this.weaponEffectValue) {
                    default -> throw new MatchException(null, null);
                    case WeaponEffectType.OFF -> WeaponEffectType.BOOMERANG;
                    case WeaponEffectType.BOOMERANG -> WeaponEffectType.EMBED;
                    case WeaponEffectType.EMBED -> WeaponEffectType.OFF;
                };
                btn.setMessage((Component)Component.literal((String)("Weapon Effect: " + this.weaponEffectValue.name())));
            }).bounds(this.width / 2 - 80, this.height / 6 - 10, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"OFF: Weapons drop normally\nBOOMERANG: Weapons return after hitting (catch them!)\nEMBED: Weapons stick in enemies and cause bleeding"))).build();
            this.addRenderableWidget((GuiEventListener)this.weaponEffectButton);
            this.aimAssistButton = Button.builder((Component)Component.literal((String)("Aim Assist: " + (this.aimAssistValue ? "ON" : "OFF"))), btn -> {
                this.aimAssistValue = !this.aimAssistValue;
                btn.setMessage((Component)Component.literal((String)("Aim Assist: " + (this.aimAssistValue ? "ON" : "OFF"))));
            }).bounds(this.width / 2 - 80, this.height / 6 + 11, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Helps aim at nearby targets"))).build();
            this.addRenderableWidget((GuiEventListener)this.aimAssistButton);
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Throwable Projectiles..."), btn -> this.client.setScreen((Screen)new ThrowableItemsScreen(this))).bounds(this.width / 2 - 80, this.height / 6 + 32, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Toggle and manage vanilla and modded items to be thrown immersively"))).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Extras..."), btn -> this.client.setScreen((Screen)new ExtrasScreen.ExtrasToggleScreen(this))).bounds(this.width / 2 - 80, this.height / 6 + 53, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"More features and settings"))).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Done"), btn -> {
                ConfigHelper.CLIENT.weaponEffect = this.weaponEffectValue;
                ConfigHelper.CLIENT.aimAssist = this.aimAssistValue;
                ConfigHelper.write(ConfigHelper.CLIENT);
                if (this.client.hasSingleplayerServer()) {
                    ConfigHelper.ACTIVE.weaponEffect = ConfigHelper.CLIENT.weaponEffect;
                    ConfigHelper.ACTIVE.aimAssist = ConfigHelper.CLIENT.aimAssist;
                }
                this.client.setScreen(this.parent);
            }).bounds(this.width / 2 - 100, this.height - 30, 200, 20).build());
        }

        public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
            this.renderBackground(context, mouseX, mouseY, delta);
            super.render(context, mouseX, mouseY, delta);
            context.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        }
    }
}

