/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client.config;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import win.demistorm.ConfigHelper;

public final class CompatScreen {
    private CompatScreen() {
    }

    public static class CompatToggleScreen
    extends Screen {
        private final Screen parent;
        private final Minecraft client = Minecraft.getInstance();
        private boolean immersiveMCThrowablesValue;
        private boolean throwConflictingItemsValue;

        protected CompatToggleScreen(Screen parent) {
            super((Component)Component.literal((String)"VR Throwing Extensions - Compat Toggles"));
            this.immersiveMCThrowablesValue = ConfigHelper.CLIENT.immersiveMCThrowables;
            this.throwConflictingItemsValue = ConfigHelper.CLIENT.throwConflictingItems;
            this.parent = parent;
        }

        public static CompatToggleScreen create(Screen parent) {
            return new CompatToggleScreen(parent);
        }

        protected void init() {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("ImmersiveMC Throwables: " + (this.immersiveMCThrowablesValue ? "ON" : "OFF"))), btn -> {
                this.immersiveMCThrowablesValue = !this.immersiveMCThrowablesValue;
                btn.setMessage((Component)Component.literal((String)("ImmersiveMC Throwables: " + (this.immersiveMCThrowablesValue ? "ON" : "OFF"))));
            }).bounds(this.width / 2 - 80, this.height / 6 - 10, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"ON: ImmersiveMC handles throwable projectiles\nOFF: For when ImmersiveMC throwing is disabled, allows VTE to throw vanilla projectiles\n"))).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Throw Conflicting Items: " + (this.throwConflictingItemsValue ? "ON" : "OFF"))), btn -> {
                this.throwConflictingItemsValue = !this.throwConflictingItemsValue;
                btn.setMessage((Component)Component.literal((String)("Throw Conflicting Items: " + (this.throwConflictingItemsValue ? "ON" : "OFF"))));
            }).bounds(this.width / 2 - 80, this.height / 6 + 11, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"ON: Allow throwing conflicting items (Climbing Claws, bows, etc.) when crouched and holding place/use keybind\nOFF: Always block these items from being thrown\n"))).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Done"), btn -> {
                ConfigHelper.CLIENT.immersiveMCThrowables = this.immersiveMCThrowablesValue;
                ConfigHelper.CLIENT.throwConflictingItems = this.throwConflictingItemsValue;
                ConfigHelper.write(ConfigHelper.CLIENT);
                if (this.client.hasSingleplayerServer()) {
                    ConfigHelper.ACTIVE.immersiveMCThrowables = ConfigHelper.CLIENT.immersiveMCThrowables;
                    ConfigHelper.ACTIVE.throwConflictingItems = ConfigHelper.CLIENT.throwConflictingItems;
                }
                this.client.setScreen(this.parent);
            }).bounds(this.width / 2 - 100, this.height - 30, 200, 20).build());
        }

        public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
            this.renderBackground(context, mouseX, mouseY, delta);
            super.render(context, mouseX, mouseY, delta);
            context.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        }
    }
}

