/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class ItemIdCommand {
    private ItemIdCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"itemID").executes(ItemIdCommand::executeItemId));
    }

    private static int executeItemId(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return 0;
        }
        ItemStack heldStack = player.getMainHandItem();
        if (heldStack.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"\u00a77Empty hand - no item to identify"), false);
            return 1;
        }
        ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey((Object)heldStack.getItem());
        String itemId = itemKey.toString();
        String itemName = heldStack.getDisplayName().getString();
        int stackSize = heldStack.getCount();
        player.displayClientMessage((Component)Component.literal((String)String.format("\u00a7aHeld Item: \u00a7f%s\u00a77 (ID: \u00a7f%s\u00a77) Count: \u00a7f%d\u00a77", itemName, itemId, stackSize)), false);
        return 1;
    }
}

