/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import win.demistorm.effects.ProjectileEffect;

public final class AddProjectileItemCommand {
    private AddProjectileItemCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"addProjectileItemID").executes(AddProjectileItemCommand::executeAddProjectileItem));
    }

    private static int executeAddProjectileItem(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return 0;
        }
        ItemStack heldStack = player.getMainHandItem();
        if (heldStack.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"\u00a7cEmpty hand - no item to add"), false);
            return 0;
        }
        ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey((Object)heldStack.getItem());
        String itemId = itemKey.toString();
        String itemName = heldStack.getDisplayName().getString();
        List<String> projectileItems = ProjectileEffect.getProjectileItemsList();
        if (projectileItems.contains(itemId)) {
            player.displayClientMessage((Component)Component.literal((String)String.format("\u00a7e%s\u00a77 (\u00a7f%s\u00a77) is \u00a76already\u00a77 in the projectile items list!", itemName, itemId)), false);
            return 0;
        }
        projectileItems.add(itemId);
        ProjectileEffect.setProjectileItemsList(projectileItems);
        ProjectileEffect.loadProjectileItemsFromConfig();
        player.displayClientMessage((Component)Component.literal((String)String.format("\u00a7aAdded \u00a7f%s\u00a77 (\u00a7f%s\u00a77) to projectile items list! \u00a77(%d items total)", itemName, itemId, projectileItems.size())), false);
        player.displayClientMessage((Component)Component.literal((String)String.format("\u00a77Tip: Configure projectile items in the config menu or type \u00a7f/itemID\u00a77 to identify items", new Object[0])), false);
        return 1;
    }
}

