/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import win.demistorm.ThrownTNTEntity;

public class ThrownTNTRenderer
extends EntityRenderer<ThrownTNTEntity> {
    private final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
    private final float scale;

    public ThrownTNTRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.scale = 0.7f;
        this.shadowStrength = 0.0f;
    }

    public void render(ThrownTNTEntity entity, float entityYaw, float tickDelta, PoseStack matrices, MultiBufferSource vcp, int light) {
        float spinThreshold;
        float speed;
        matrices.pushPose();
        Vec3 velocity = entity.getDeltaMovement();
        float age = (float)entity.tickCount + tickDelta;
        float handRollDeg = entity.getHandRoll();
        if (velocity.length() > 0.001) {
            float yaw = (float)(Mth.atan2((double)velocity.z, (double)velocity.x) * 180.0 / Math.PI);
            matrices.mulPose(Axis.YP.rotationDegrees(90.0f - yaw));
            float hor = Mth.sqrt((float)((float)(velocity.x * velocity.x + velocity.z * velocity.z)));
            float pitch = (float)(Mth.atan2((double)velocity.y, (double)hor) * 180.0 / Math.PI);
            matrices.mulPose(Axis.XP.rotationDegrees(-pitch));
            matrices.mulPose(Axis.ZP.rotationDegrees(-handRollDeg));
        }
        float spinSpeed = (speed = (float)velocity.length()) > (spinThreshold = 0.1f) ? 15.0f : 0.0f;
        float spin = age * spinSpeed % 360.0f;
        matrices.mulPose(Axis.XP.rotationDegrees(spin));
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrices.scale(this.scale, this.scale, this.scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack tntItemStack = new ItemStack((ItemLike)Items.TNT);
        try {
            this.itemRenderer.renderStatic(tntItemStack, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, light, OverlayTexture.NO_OVERLAY, matrices, vcp, (Level)Minecraft.getInstance().level, 0);
        }
        catch (Exception e) {
            System.err.println("VR Throwing Extensions: Could not render thrown TNT: " + e.getMessage());
        }
        matrices.popPose();
        super.render((Entity)entity, entityYaw, tickDelta, matrices, vcp, light);
    }

    @NotNull
    public ResourceLocation getTextureLocation(ThrownTNTEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

