/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import win.demistorm.ThrownProjectileEntity;

public class ThrownItemRenderer
extends EntityRenderer<ThrownProjectileEntity> {
    private final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
    private final float scale;

    public ThrownItemRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.scale = 0.7f;
        this.shadowStrength = 0.0f;
    }

    public void render(ThrownProjectileEntity entity, float entityYaw, float tickDelta, PoseStack matrices, MultiBufferSource vcp, int light) {
        matrices.pushPose();
        ItemStack itemStack = entity.getItem();
        Vec3 velocity = entity.getDeltaMovement();
        float age = (float)entity.tickCount + tickDelta;
        float handRollDeg = entity.getHandRoll();
        boolean isCatching = entity.isCatching();
        boolean isBounceActive = entity.isBounceActive();
        boolean isEmbedded = entity.isEmbedded();
        if (isEmbedded) {
            matrices.mulPose(Axis.YP.rotationDegrees(90.0f - entity.getEmbedYaw()));
            matrices.mulPose(Axis.XP.rotationDegrees(-entity.getEmbedPitch()));
            matrices.mulPose(Axis.ZP.rotationDegrees(entity.getEmbedTilt()));
            matrices.mulPose(Axis.XP.rotationDegrees(entity.getEmbedRoll()));
            matrices.scale(this.scale, this.scale, this.scale);
            matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
            try {
                this.itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, light, OverlayTexture.NO_OVERLAY, matrices, vcp, (Level)Minecraft.getInstance().level, 0);
            }
            catch (Exception e) {
                System.err.println("VR Throwing Extensions: Could not render embedded item: " + e.getMessage());
            }
            matrices.popPose();
            super.render((Entity)entity, entityYaw, tickDelta, matrices, vcp, light);
            return;
        }
        if (velocity.length() > 0.001) {
            float yaw = (float)(Mth.atan2((double)velocity.z, (double)velocity.x) * 180.0 / Math.PI);
            matrices.mulPose(Axis.YP.rotationDegrees(90.0f - yaw));
            float hor = Mth.sqrt((float)((float)(velocity.x * velocity.x + velocity.z * velocity.z)));
            float pitch = (float)(Mth.atan2((double)velocity.y, (double)hor) * 180.0 / Math.PI);
            matrices.mulPose(Axis.XP.rotationDegrees(-pitch));
            matrices.mulPose(Axis.ZP.rotationDegrees(-handRollDeg));
        }
        if (isCatching) {
            float smoothSpin = age * 5.0f % 360.0f;
            matrices.mulPose(Axis.XP.rotationDegrees(smoothSpin));
            float bobOffset = Mth.sin((float)(age * 0.5f)) * 0.05f;
            matrices.translate(0.0f, bobOffset, 0.0f);
        } else if (isBounceActive) {
            float returnSpin = age * 8.0f % 360.0f;
            matrices.mulPose(Axis.XP.rotationDegrees(returnSpin));
            float wobble = Mth.sin((float)(age * 0.35f)) * 3.0f;
            matrices.mulPose(Axis.YP.rotationDegrees(wobble));
            float pulseScale = 1.0f + Mth.sin((float)(age * 0.4f)) * 0.05f;
            matrices.scale(pulseScale, pulseScale, pulseScale);
        } else {
            float spinSpeed = 15.0f;
            float spin = age * spinSpeed % 360.0f;
            matrices.mulPose(Axis.XP.rotationDegrees(spin));
        }
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrices.scale(this.scale, this.scale, this.scale);
        try {
            this.itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, light, OverlayTexture.NO_OVERLAY, matrices, vcp, (Level)Minecraft.getInstance().level, 0);
        }
        catch (Exception e) {
            System.err.println("VR Throwing Extensions: Could not render thrown item: " + e.getMessage());
        }
        matrices.popPose();
        super.render((Entity)entity, entityYaw, tickDelta, matrices, vcp, light);
    }

    @NotNull
    public ResourceLocation getTextureLocation(ThrownProjectileEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

