/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client;

import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.VRAPI;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.api.client.VRClientAPI;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRBodyPartData;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.api.data.VRPoseHistory;
import win.demistorm.ConfigHelper;
import win.demistorm.ModCompat;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.AimHelper;
import win.demistorm.client.ClientNetworkHelper;
import win.demistorm.client.TNTHelper;

public class ThrowHelper {
    private static boolean active = false;
    private static boolean catchActive = false;
    private static boolean useBindHeld = false;
    private static boolean playerCrouched = false;
    private static boolean cancelBreaking = false;
    private static ItemStack heldItem = ItemStack.EMPTY;
    private static ThrownProjectileEntity targetProjectile = null;
    private static int ticksHeld = 0;
    private static int catchTicksHeld = 0;
    private static final TNTHelper tntHelper = new TNTHelper();
    private static final double minThrowDistance = 0.08;
    private static final int maxPoseHistoryTicks = 6;
    private static final double speedThreshold = 0.1;
    private static final double throwVelocityThreshold = 0.06;
    private static final double weakVelThreshold = 0.06;
    private static final double strongVelThreshold = 0.3;
    private static final double weakMultiplier = 3.5;
    private static final double strongMultiplier = 8.0;
    private static final double catchMaxDistance = 3.0;
    private static final double catchMagnetStrength = 0.1;
    private static final double catchCompletionDistance = 0.2;
    private static final int minCatchTicks = 3;

    public static boolean cancellingBreaks() {
        return active && cancelBreaking || catchActive;
    }

    public static boolean cancellingUse() {
        return active;
    }

    private static double calculateVelocityMultiplier(double velocity) {
        if (velocity <= 0.06) {
            return 3.5;
        }
        if (velocity >= 0.3) {
            return 8.0;
        }
        double t = (velocity - 0.06) / 0.24;
        t *= t;
        return 3.5 + t * 4.5;
    }

    private static boolean throwCatching(LocalPlayer player, boolean attackPressed) {
        ItemStack activeStack = player.getMainHandItem();
        if (!activeStack.isEmpty()) {
            if (catchActive) {
                ThrowHelper.cancelCatch();
                VRThrowingExtensions.log.debug("[VR Catch] Canceled: Player switched to occupied slot");
            }
            return false;
        }
        VRPose pose = VRClientAPI.instance().getPreTickWorldPose();
        if (pose == null) {
            return catchActive;
        }
        VRBodyPartData hand = pose.getHand(InteractionHand.MAIN_HAND);
        if (hand == null) {
            return catchActive;
        }
        Vec3 handPos = hand.getPos();
        if (!catchActive && attackPressed) {
            ThrownProjectileEntity nearestProjectile = ThrowHelper.findNearestProjectile(player, handPos);
            if (nearestProjectile != null) {
                ThrowHelper.startCatch(nearestProjectile);
                VRThrowingExtensions.log.debug("[VR Catch] Started catching projectile...");
                return true;
            }
        } else {
            if (catchActive && attackPressed) {
                if (targetProjectile == null || targetProjectile.isRemoved()) {
                    ThrowHelper.cancelCatch();
                    VRThrowingExtensions.log.debug("[VR Catch] Canceled: Target projectile no longer exists");
                    return false;
                }
                ThrowHelper.updateCatchMagnetism(handPos, hand.getRotation());
                double distanceToHand = targetProjectile.position().distanceTo(handPos);
                if (distanceToHand <= 0.2 && ++catchTicksHeld >= 3) {
                    ThrowHelper.completeCatch();
                    VRThrowingExtensions.log.debug("[VR Catch] Completed catch!");
                    return false;
                }
                return true;
            }
            if (catchActive) {
                ThrowHelper.cancelCatch();
                VRThrowingExtensions.log.debug("[VR Catch] Canceled: Attack button released");
                return false;
            }
        }
        return catchActive;
    }

    private static ThrownProjectileEntity findNearestProjectile(LocalPlayer player, Vec3 handPos) {
        Vec3 min = handPos.subtract(3.0, 3.0, 3.0);
        Vec3 max = handPos.add(3.0, 3.0, 3.0);
        AABB searchBox = new AABB(min, max);
        return player.level().getEntitiesOfClass(ThrownProjectileEntity.class, searchBox, entity -> {
            if (entity.isRemoved()) {
                return false;
            }
            double distance = entity.position().distanceTo(handPos);
            return distance <= 3.0;
        }).stream().min(Comparator.comparingDouble(e -> e.position().distanceTo(handPos))).orElse(null);
    }

    private static void startCatch(ThrownProjectileEntity projectile) {
        catchActive = true;
        targetProjectile = projectile;
        catchTicksHeld = 0;
        ClientNetworkHelper.sendCatchToServer(projectile, true);
    }

    private static void updateCatchMagnetism(Vec3 handPos, Quaternionfc handRotation) {
        if (targetProjectile == null) {
            return;
        }
        Vec3 projectilePos = targetProjectile.position();
        Vec3 toHand = handPos.subtract(projectilePos);
        double distance = toHand.length();
        if (distance > 0.001) {
            Vec3 magnetEffect = toHand.normalize().scale(0.1);
            Vec3 currentVel = targetProjectile.getDeltaMovement();
            Vec3 newVel = currentVel.scale(0.6).add(magnetEffect);
            ClientNetworkHelper.sendCatchUpdateToServer(targetProjectile, newVel, handRotation);
        }
    }

    private static void completeCatch() {
        if (targetProjectile == null) {
            return;
        }
        ClientNetworkHelper.sendCatchCompleteToServer(targetProjectile);
        ThrowHelper.resetCatch();
        VRClientAPI.instance().triggerHapticPulse(VRBodyPart.fromInteractionHand((InteractionHand)InteractionHand.MAIN_HAND), 0.5f);
    }

    private static void cancelCatch() {
        if (targetProjectile != null) {
            ClientNetworkHelper.sendCatchToServer(targetProjectile, false);
        }
        ThrowHelper.resetCatch();
    }

    private static Vec3 historicalHandPosition(VRPoseHistory hist) {
        try {
            VRPose pose2 = hist.getHistoricalData(2);
            VRBodyPartData hand2 = pose2.getHand(InteractionHand.MAIN_HAND);
            if (hand2 != null) {
                return hand2.getPos();
            }
        }
        catch (IllegalArgumentException pose2) {
            // empty catch block
        }
        VRPose now = VRClientAPI.instance().getPreTickWorldPose();
        assert (now != null);
        return now.getHand(InteractionHand.MAIN_HAND).getPos();
    }

    private static void resetCatch() {
        catchActive = false;
        targetProjectile = null;
        catchTicksHeld = 0;
    }

    private static void reset() {
        active = false;
        useBindHeld = false;
        playerCrouched = false;
        cancelBreaking = false;
        heldItem = ItemStack.EMPTY;
        ticksHeld = 0;
        tntHelper.stopTracking();
    }

    public static class ThrowTracker
    implements Tracker {
        public Tracker.ProcessType processType() {
            return Tracker.ProcessType.PER_TICK;
        }

        public boolean isActive(LocalPlayer player) {
            return player != null && VRAPI.instance().isVRPlayer((Player)player);
        }

        public void activeProcess(LocalPlayer player) {
            Minecraft mc = Minecraft.getInstance();
            if (player == null || !VRAPI.instance().isVRPlayer((Player)player)) {
                return;
            }
            boolean attackPressed = mc.options.keyAttack.isDown();
            boolean placePressed = mc.options.keyUse.isDown();
            if (ThrowHelper.throwCatching(player, attackPressed)) {
                return;
            }
            if (tntHelper.isLit()) {
                tntHelper.emitSmokeParticles(player);
            }
            if (!active && attackPressed) {
                boolean holdingTNT;
                ItemStack held = player.getMainHandItem();
                if (ModCompat.throwingDisabled(held, player.isCrouching(), placePressed)) {
                    return;
                }
                boolean bl = holdingTNT = ConfigHelper.ACTIVE.throwableTNT && held.is(Items.TNT);
                if (holdingTNT) {
                    tntHelper.startTracking(player);
                    VRThrowingExtensions.log.debug("[VR Throw] Started tracking TNT with flint & steel");
                }
                heldItem = held.copy();
                ticksHeld = 0;
                active = true;
                useBindHeld = placePressed;
                playerCrouched = player.isCrouching();
                cancelBreaking = false;
                VRThrowingExtensions.log.debug("[VR Throw] Hold trace started with item: {}", (Object)heldItem);
            } else if (active && attackPressed) {
                double speed;
                VRPoseHistory hist;
                ticksHeld = Math.min(ticksHeld + 1, 6);
                useBindHeld |= placePressed;
                playerCrouched = player.isCrouching();
                if (tntHelper.isTracking() && tntHelper.checkSwipeMotion(player)) {
                    VRThrowingExtensions.log.debug("[VR Throw] TNT lit via flint & steel swipe!");
                }
                if (!cancelBreaking && (hist = VRAPI.instance().getHistoricalVRPoses((Player)player)) != null && (speed = hist.averageSpeed(VRBodyPart.MAIN_HAND, 2, true)) > 0.1) {
                    cancelBreaking = true;
                    VRThrowingExtensions.log.debug("[VR Throw] speed threshold crossed, mining blocked");
                }
            } else if (active) {
                if (ticksHeld >= 5) {
                    int usedTicks;
                    Vec3 handMovement;
                    VRPoseHistory history = VRAPI.instance().getHistoricalVRPoses((Player)player);
                    if (history != null && (handMovement = history.netMovement(VRBodyPart.MAIN_HAND, usedTicks = Math.min(ticksHeld, 6), true)) != null) {
                        double relativeMovedDist = handMovement.length();
                        if (relativeMovedDist > 0.08) {
                            Vec3 relativeVel = history.averageVelocity(VRBodyPart.MAIN_HAND, usedTicks, true);
                            if (relativeVel != null) {
                                double velLength = relativeVel.length();
                                if (velLength >= 0.06) {
                                    Vec3 origin = ThrowHelper.historicalHandPosition(history);
                                    double dynamicMultiplier = ThrowHelper.calculateVelocityMultiplier(velLength);
                                    Vec3 launchVel = relativeVel.scale(dynamicMultiplier);
                                    Vec3 assistedVel = AimHelper.applyAimAssist(player, origin, launchVel);
                                    VRPose pose = VRClientAPI.instance().getPreTickWorldPose();
                                    assert (pose != null);
                                    VRBodyPartData hand = pose.getHand(InteractionHand.MAIN_HAND);
                                    Quaternionfc q = hand.getRotation();
                                    Vector3f fwd = new Vector3f(0.0f, 0.0f, -1.0f).rotate(q).normalize();
                                    Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f).rotate(q).normalize();
                                    Vector3f projCtrlUp = up.sub((Vector3fc)new Vector3f((Vector3fc)fwd).mul(up.dot((Vector3fc)fwd))).normalize();
                                    Vector3f projWorldUp = new Vector3f(0.0f, 1.0f, 0.0f).sub((Vector3fc)new Vector3f((Vector3fc)fwd).mul(fwd.y)).normalize();
                                    float rollRad = projCtrlUp.angleSigned((Vector3fc)projWorldUp, (Vector3fc)fwd);
                                    float rollDeg = (float)Math.toDegrees(rollRad);
                                    try {
                                        if (ConfigHelper.ACTIVE.throwableTNT && tntHelper.isLit()) {
                                            ClientNetworkHelper.sendThrowTNTPacket(origin, assistedVel, rollDeg);
                                            VRThrowingExtensions.log.debug("[VR Throw] Thrown lit TNT!");
                                        } else {
                                            ClientNetworkHelper.sendToServer(origin, assistedVel, useBindHeld, playerCrouched, rollDeg);
                                        }
                                    }
                                    catch (Exception e) {
                                        VRThrowingExtensions.log.error("Error sending throw packet to server: {}", (Object)e.getMessage());
                                        ThrowHelper.reset();
                                        return;
                                    }
                                    VRClientAPI.instance().triggerHapticPulse(VRBodyPart.fromInteractionHand((InteractionHand)InteractionHand.MAIN_HAND), 0.2f);
                                } else {
                                    VRThrowingExtensions.log.debug("[VR Throw] Relative velocity too slow: {}", (Object)velLength);
                                }
                            }
                        } else {
                            VRThrowingExtensions.log.debug("[VR Throw] Insufficient relative movement: {}", (Object)relativeMovedDist);
                        }
                    }
                } else {
                    VRThrowingExtensions.log.debug("[VR Throw] Released too early. Held {} ticks.", (Object)ticksHeld);
                }
                ThrowHelper.reset();
            }
        }

        public void inactiveProcess(LocalPlayer player) {
        }
    }
}

