/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.VRAPI;
import org.vivecraft.api.client.VRClientAPI;
import org.vivecraft.api.data.VRBodyPartData;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.api.data.VRPoseHistory;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.ClientNetworkHelper;
import win.demistorm.client.particles.TNTSmokeParticle;

public class TNTHelper {
    private boolean isLit = false;
    private boolean isTracking = false;
    private LocalPlayer trackingPlayer = null;
    private int ticksSinceLit = 0;
    private static final int TNT_FUSE_TICKS = 100;
    private static final float proximityDistance = 0.2f;

    public boolean checkSwipeMotion(LocalPlayer player) {
        boolean swipeDetected;
        if (!this.isTracking || this.trackingPlayer == null) {
            return false;
        }
        if (!this.isHoldingFlintAndSteel(player)) {
            return false;
        }
        VRPoseHistory history = VRAPI.instance().getHistoricalVRPoses((Player)player);
        if (history == null) {
            return false;
        }
        boolean wasOutside = false;
        boolean wasInside = false;
        boolean isOutsideAgain = false;
        for (int i = 4; i >= 0; --i) {
            VRPose historicalPose;
            try {
                historicalPose = history.getHistoricalData(i);
            }
            catch (Exception e) {
                continue;
            }
            if (historicalPose == null) continue;
            VRBodyPartData mainHandData = historicalPose.getHand(InteractionHand.MAIN_HAND);
            VRBodyPartData offHandData = historicalPose.getHand(InteractionHand.OFF_HAND);
            if (mainHandData == null || offHandData == null) continue;
            Vector3f mainHandPos = new Vector3f((float)mainHandData.getPos().x, (float)mainHandData.getPos().y, (float)mainHandData.getPos().z);
            Vector3f offHandPos = new Vector3f((float)offHandData.getPos().x, (float)offHandData.getPos().y, (float)offHandData.getPos().z);
            Vector3f offset = new Vector3f((Vector3fc)offHandPos).sub((Vector3fc)mainHandPos);
            float distance = offset.length();
            if (i == 0) {
                isOutsideAgain = distance >= 0.2f;
                continue;
            }
            if (i <= 3) {
                if (!(distance < 0.2f)) continue;
                wasInside = true;
                continue;
            }
            wasOutside = distance >= 0.2f;
        }
        boolean bl = swipeDetected = wasOutside && wasInside && isOutsideAgain;
        if (swipeDetected && !this.isLit) {
            this.isLit = true;
            this.ticksSinceLit = 0;
            ClientNetworkHelper.sendTNTLitPacket();
            return true;
        }
        return false;
    }

    public boolean isHoldingFlintAndSteel(LocalPlayer player, InteractionHand hand) {
        if (player == null) {
            return false;
        }
        return player.getItemInHand(hand).is(Items.FLINT_AND_STEEL);
    }

    public boolean isHoldingFlintAndSteel(LocalPlayer player) {
        return this.isHoldingFlintAndSteel(player, InteractionHand.OFF_HAND);
    }

    public void startTracking(LocalPlayer player) {
        this.isTracking = true;
        this.isLit = false;
        this.trackingPlayer = player;
    }

    public void stopTracking() {
        this.isTracking = false;
        this.isLit = false;
        this.trackingPlayer = null;
        this.ticksSinceLit = 0;
    }

    public boolean isLit() {
        return this.isLit;
    }

    public boolean isTracking() {
        return this.isTracking;
    }

    public void emitSmokeParticles(LocalPlayer player) {
        if (!this.isLit || this.trackingPlayer == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        ++this.ticksSinceLit;
        int remainingTicks = 100 - this.ticksSinceLit;
        if (remainingTicks <= 0) {
            this.isLit = false;
            this.ticksSinceLit = 0;
            return;
        }
        VRPose pose = VRClientAPI.instance().getPreTickWorldPose();
        if (pose == null) {
            return;
        }
        VRBodyPartData hand = pose.getHand(InteractionHand.MAIN_HAND);
        if (hand == null) {
            return;
        }
        Vec3 handPos = hand.getPos();
        Quaternionfc rotation = hand.getRotation();
        Vector3f forward = new Vector3f(0.0f, 0.0f, -1.0f).rotate(rotation).normalize();
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f).rotate(rotation).normalize();
        Vec3 particlePos = handPos.add(new Vec3((double)forward.x * 0.15, (double)forward.y * 0.15, (double)forward.z * 0.15)).add(new Vec3((double)up.x * 0.1, (double)up.y * 0.1, (double)up.z * 0.1));
        float[] color = this.calculateSmokeColor(remainingTicks);
        try {
            TNTSmokeParticle.spawnColoredSmoke(color[0], color[1], color[2], particlePos.x, particlePos.y, particlePos.z, 0.5f);
        }
        catch (Exception e) {
            VRThrowingExtensions.log.debug("Failed to spawn smoke particle: {}", (Object)e.getMessage());
        }
    }

    private float[] calculateSmokeColor(int remainingFuse) {
        float b;
        float g;
        float r;
        if (remainingFuse > 75) {
            float t = (float)(remainingFuse - 75) / 25.0f;
            r = 0.05f + t * 0.05f;
            g = 0.05f + t * 0.05f;
            b = 0.05f + t * 0.05f;
        } else if (remainingFuse > 50) {
            float t = (float)(remainingFuse - 50) / 25.0f;
            r = 0.3f + (1.0f - t) * 0.7f;
            g = 0.0f;
            b = 0.0f;
        } else if (remainingFuse > 25) {
            float t = (float)(remainingFuse - 25) / 25.0f;
            r = 1.0f;
            g = (1.0f - t) * 0.5f;
            b = 0.0f;
        } else {
            float t = (float)remainingFuse / 25.0f;
            r = 1.0f;
            g = 0.5f + (1.0f - t) * 0.5f;
            b = 1.0f - t;
        }
        return new float[]{r, g, b};
    }
}

