/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client;

import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.network.Network;
import win.demistorm.network.data.CatchCompleteData;
import win.demistorm.network.data.CatchData;
import win.demistorm.network.data.CatchUpdateData;
import win.demistorm.network.data.TNTLitData;
import win.demistorm.network.data.ThrowData;
import win.demistorm.network.data.ThrowTNTData;

public final class ClientNetworkHelper {
    private ClientNetworkHelper() {
    }

    public static void sendToServer(Vec3 pos, Vec3 velocity, boolean useBindHeld, boolean playerCrouched, float rollDeg) {
        VRThrowingExtensions.log.debug("ClientNetworkHelper: Sending throw. pos={} vel={} useBindHeld={} playerCrouched={}", new Object[]{pos, velocity, useBindHeld, playerCrouched});
        Network.INSTANCE.sendToServer(new ThrowData(pos.x, pos.y, pos.z, velocity.x, velocity.y, velocity.z, useBindHeld, playerCrouched, rollDeg));
    }

    public static void sendCatchToServer(ThrownProjectileEntity entity, boolean startCatch) {
        VRThrowingExtensions.log.debug("ClientNetworkHelper: Sending catch start/cancel. entity={} start={}", (Object)entity.getId(), (Object)startCatch);
        Network.INSTANCE.sendToServer(new CatchData(entity.getId(), startCatch));
    }

    public static void sendCatchUpdateToServer(ThrownProjectileEntity entity, Vec3 newVelocity, Quaternionfc handRotation) {
        Vector3f fwd = new Vector3f(0.0f, 0.0f, -1.0f).rotate(handRotation).normalize();
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f).rotate(handRotation).normalize();
        Vector3f projCtrlUp = up.sub((Vector3fc)new Vector3f((Vector3fc)fwd).mul(up.dot((Vector3fc)fwd))).normalize();
        Vector3f projWorldUp = new Vector3f(0.0f, 1.0f, 0.0f).sub((Vector3fc)new Vector3f((Vector3fc)fwd).mul(fwd.y)).normalize();
        float rollRad = projCtrlUp.angleSigned((Vector3fc)projWorldUp, (Vector3fc)fwd);
        float rollDeg = (float)Math.toDegrees(rollRad);
        VRThrowingExtensions.log.debug("ClientNetworkHelper: Sending catch update. entity={} vel={} roll={}", new Object[]{entity.getId(), newVelocity, Float.valueOf(rollDeg)});
        Network.INSTANCE.sendToServer(new CatchUpdateData(entity.getId(), newVelocity.x, newVelocity.y, newVelocity.z, rollDeg));
    }

    public static void sendCatchCompleteToServer(ThrownProjectileEntity entity) {
        VRThrowingExtensions.log.debug("ClientNetworkHelper: Sending catch complete. entity={}", (Object)entity.getId());
        Network.INSTANCE.sendToServer(new CatchCompleteData(entity.getId()));
    }

    public static void sendTNTLitPacket() {
        VRThrowingExtensions.log.debug("ClientNetworkHelper: Sending TNT lit event");
        Network.INSTANCE.sendToServer(new TNTLitData());
    }

    public static void sendThrowTNTPacket(Vec3 pos, Vec3 velocity, float rollDeg) {
        VRThrowingExtensions.log.debug("ClientNetworkHelper: Sending lit TNT throw. pos={} vel={} roll={}", new Object[]{pos, velocity, Float.valueOf(rollDeg)});
        Network.INSTANCE.sendToServer(new ThrowTNTData(pos.x, pos.y, pos.z, velocity.x, velocity.y, velocity.z, rollDeg));
    }
}

