/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.EntityType;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.demistorm.ConfigHelper;
import win.demistorm.Platform;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.ThrownTNTEntity;
import win.demistorm.command.ItemInfoCommand;
import win.demistorm.effects.ProjectileEffect;
import win.demistorm.network.Network;
import win.demistorm.network.TNTServer;

public class VRThrowingExtensions {
    public static final String MOD_ID = "vr-throwing-extensions";
    public static final Logger log = LoggerFactory.getLogger((String)"vr-throwing-extensions");
    public static EntityType<ThrownProjectileEntity> THROWN_ITEM_TYPE;
    public static EntityType<ThrownTNTEntity> THROWN_TNT_TYPE;
    public static final boolean debugMode = false;

    public static void initialize() {
        log.info("VR Throwing Extensions (SERVER) starting!");
        ConfigHelper.loadOrCreateServerConfig();
        ProjectileEffect.loadOrCreateConfig();
        Network.initialize();
        Platform.registerCommands(dispatcher -> ItemInfoCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher));
        VRThrowingExtensions.registerServerEventHandlers();
        TNTServer.instance().registerTickHandler();
    }

    private static void registerServerEventHandlers() {
        Platform.registerServerPlayerJoinListener(player -> {
            ConfigHelper.sendConfigToPlayer(player);
            log.debug("Sent config to joining player: {}", (Object)player.getName().getString());
        });
    }

    static {
        Configurator.setLevel((String)MOD_ID, (Level)Level.INFO);
    }
}

