/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.portal.DimensionTransition;
import org.jetbrains.annotations.Nullable;
import win.demistorm.client.particles.TNTSmokeParticle;

public class ThrownTNTEntity
extends PrimedTnt {
    private static final EntityDataAccessor<Float> HAND_ROLL = SynchedEntityData.defineId(ThrownTNTEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final ExplosionDamageCalculator USED_PORTAL_DAMAGE_CALCULATOR = new ExplosionDamageCalculator(){

        public boolean shouldBlockExplode(Explosion explosion, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, float f) {
            return blockState.is(Blocks.NETHER_PORTAL) ? false : super.shouldBlockExplode(explosion, blockGetter, blockPos, blockState, f);
        }

        public Optional<Float> getBlockExplosionResistance(Explosion explosion, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
            return blockState.is(Blocks.NETHER_PORTAL) ? Optional.empty() : super.getBlockExplosionResistance(explosion, blockGetter, blockPos, blockState, fluidState);
        }
    };
    private boolean usedPortal;
    private float explosionPower = 4.0f;

    public ThrownTNTEntity(EntityType<? extends PrimedTnt> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAND_ROLL, (Object)Float.valueOf(0.0f));
    }

    public void setHandRoll(float deg) {
        this.entityData.set(HAND_ROLL, (Object)Float.valueOf(deg));
    }

    public float getHandRoll() {
        return ((Float)this.entityData.get(HAND_ROLL)).floatValue();
    }

    private void setUsedPortal(boolean bl) {
        this.usedPortal = bl;
    }

    @Nullable
    public Entity changeDimension(DimensionTransition dimensionTransition) {
        Entity entity = super.changeDimension(dimensionTransition);
        if (entity instanceof PrimedTnt) {
            PrimedTnt primedTnt = (PrimedTnt)entity;
            this.setUsedPortal(true);
        }
        return entity;
    }

    public void tick() {
        this.handlePortal();
        this.applyGravity();
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
        }
        int i = this.getFuse() - 1;
        this.setFuse(i);
        if (i <= 0) {
            this.discard();
            if (!this.level().isClientSide) {
                this.explode();
            }
        } else {
            this.updateInWaterStateAndDoFluidPushing();
            if (this.level().isClientSide) {
                this.spawnColoredSmokeParticle();
            }
        }
    }

    private void spawnColoredSmokeParticle() {
        float b;
        float g;
        float r;
        int remainingFuse = this.getFuse();
        if (remainingFuse > 75) {
            float t = (float)(remainingFuse - 75) / 25.0f;
            r = 0.05f + t * 0.05f;
            g = 0.05f + t * 0.05f;
            b = 0.05f + t * 0.05f;
        } else if (remainingFuse > 50) {
            float t = (float)(remainingFuse - 50) / 25.0f;
            r = 0.3f + (1.0f - t) * 0.7f;
            g = 0.0f;
            b = 0.0f;
        } else if (remainingFuse > 25) {
            float t = (float)(remainingFuse - 25) / 25.0f;
            r = 1.0f;
            g = (1.0f - t) * 0.5f;
            b = 0.0f;
        } else {
            float t = (float)remainingFuse / 25.0f;
            r = 1.0f;
            g = 0.5f + (1.0f - t) * 0.5f;
            b = 1.0f - t;
        }
        TNTSmokeParticle.spawnColoredSmoke(r, g, b, this.getX(), this.getY() + 0.5, this.getZ());
    }

    private void explode() {
        Level var2 = this.level();
        if (var2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)var2;
            this.level().explode((Entity)this, Explosion.getDefaultDamageSource((Level)this.level(), (Entity)this), (ExplosionDamageCalculator)(this.usedPortal ? USED_PORTAL_DAMAGE_CALCULATOR : null), this.getX(), this.getY(0.0625), this.getZ(), this.explosionPower, false, Level.ExplosionInteraction.TNT);
        }
    }
}

