/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import win.demistorm.ConfigHelper;
import win.demistorm.Platform;
import win.demistorm.effects.ProjectileEffect;

public class ModCompat {
    private static final boolean IMCLoaded = Platform.isModLoaded("immersivemc");
    private static final Set<ResourceLocation> blockedItems = new HashSet<ResourceLocation>();

    public static boolean throwingDisabled(ItemStack stack, boolean isCrouching, boolean placePressed) {
        if (stack.isEmpty()) {
            return true;
        }
        Item item = stack.getItem();
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        if (IMCLoaded && ModCompat.immersiveMCExceptions(id)) {
            if (ConfigHelper.ACTIVE.immersiveMCThrowables) {
                return true;
            }
            return !ModCompat.isThrowableProjectileItem(stack);
        }
        boolean isVivecraftDisabled = ModCompat.isVivecraftItem(stack);
        if (isVivecraftDisabled) {
            return !ConfigHelper.ACTIVE.throwConflictingItems || !isCrouching || !placePressed;
        }
        boolean isBlocked = blockedItems.contains(id);
        if (isBlocked) {
            return !ConfigHelper.ACTIVE.throwConflictingItems || !isCrouching || !placePressed;
        }
        return false;
    }

    private static boolean isThrowableProjectileItem(ItemStack stack) {
        Item item = stack.getItem();
        ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey((Object)item);
        return ProjectileEffect.getProjectileItemsList().contains(itemKey.toString());
    }

    private static boolean immersiveMCExceptions(ResourceLocation itemId) {
        return itemId.getPath().equals("snowball") || itemId.getPath().equals("ender_pearl") || itemId.getPath().equals("egg") || itemId.getPath().equals("experience_bottle") || itemId.getPath().startsWith("splash_potion") || itemId.getPath().startsWith("lingering_potion") || itemId.getPath().startsWith("trident") || itemId.getPath().startsWith("fishing_rod");
    }

    private static boolean isVivecraftItem(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        ComponentContents componentContents = stack.getHoverName().getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContent = (TranslatableContents)componentContents;
            String translationKey = translatableContent.getKey();
            return translationKey.equals("vivecraft.item.climbclaws") || translationKey.equals("vivecraft.item.jumpboots");
        }
        return false;
    }

    static {
        blockedItems.add(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"bow"));
        blockedItems.add(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"crossbow"));
    }
}

